/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.network;

import com.buuz135.portality.Portality;
import com.buuz135.portality.data.PortalDataManager;
import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.data.TokenPortalInformation;
import com.buuz135.portality.gui.PortalsScreen;
import com.buuz135.portality.tile.ControllerTile;
import com.buuz135.portality.util.BlockPosUtils;
import com.hrznstudio.titanium.network.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PortalNetworkMessage {
    public static void sendInformationToPlayer(ServerPlayerEntity playerEntity, boolean interdimensional, BlockPos pos, int distance, HashMap<String, CompoundNBT> tokens) {
        ArrayList<PortalInformation> infos = new ArrayList<PortalInformation>();
        tokens.forEach((s, compoundNBT) -> infos.add(new TokenPortalInformation(playerEntity.func_110124_au(), (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compoundNBT.func_74779_i("Dimension"))), new BlockPos(compoundNBT.func_74762_e("X"), compoundNBT.func_74762_e("Y"), compoundNBT.func_74762_e("Z")), (String)s)));
        infos.addAll(PortalDataManager.getData((IWorld)playerEntity.field_70170_p).getInformationList());
        infos.removeIf(information -> information.getDimension().equals((Object)playerEntity.func_71121_q().func_234923_W_()) && information.getLocation().equals((Object)pos));
        infos.removeIf(information -> {
            ServerWorld world = playerEntity.func_184102_h().func_71218_a(information.getDimension());
            return world.func_175625_s(information.getLocation()) instanceof ControllerTile && !((ControllerTile)world.func_175625_s(information.getLocation())).isFormed();
        });
        infos.removeIf(information -> !interdimensional && !playerEntity.func_71121_q().func_234923_W_().equals(information.getDimension()));
        infos.removeIf(information -> interdimensional && !playerEntity.func_71121_q().func_234923_W_().equals(information.getDimension()) && !information.isInterdimensional());
        infos.removeIf(information -> {
            ServerWorld world = playerEntity.func_130014_f_().func_73046_m().func_71218_a(information.getDimension());
            TileEntity entity = world.func_175625_s(information.getLocation());
            return entity instanceof ControllerTile && !interdimensional && (!playerEntity.func_71121_q().func_234923_W_().equals(information.getDimension()) || !information.getLocation().func_218137_a((IPosition)new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), (double)distance) || !information.getLocation().func_218137_a((IPosition)new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), (double)BlockPosUtils.getMaxDistance(((ControllerTile)entity).getLength())));
        });
        Portality.NETWORK.get().sendTo((Object)new Response(infos), playerEntity.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static class Response
    extends Message {
        private CompoundNBT compoundNBT = new CompoundNBT();

        public Response() {
        }

        public Response(List<PortalInformation> information) {
            information.forEach(portalInformation -> this.compoundNBT.func_218657_a(portalInformation.getId().toString(), (INBT)portalInformation.writetoNBT()));
        }

        protected void handleMessage(NetworkEvent.Context context) {
            Minecraft.func_71410_x().func_212871_a_(() -> {
                if (Minecraft.func_71410_x().field_71462_r instanceof PortalsScreen) {
                    ArrayList<PortalInformation> information = new ArrayList<PortalInformation>();
                    this.compoundNBT.func_150296_c().forEach(s -> information.add(PortalInformation.readFromNBT(this.compoundNBT.func_74775_l(s))));
                    ((PortalsScreen)Minecraft.func_71410_x().field_71462_r).refresh(information);
                }
            });
        }
    }
}

