/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs.particles;

import com.almostreliable.ponderjs.mixin.ParticleAccessor;
import com.almostreliable.ponderjs.mixin.PonderWorldAccessor;
import com.almostreliable.ponderjs.particles.ParticleDataBuilder;
import com.almostreliable.ponderjs.particles.ParticleTransformation;
import com.almostreliable.ponderjs.util.PonderErrorHelper;
import com.almostreliable.ponderjs.util.PonderPlatform;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.fluids.particle.FluidParticleData;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.instruction.PonderInstruction;
import com.simibubi.create.foundation.ponder.instruction.TickingInstruction;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.rhino.mod.util.color.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_703;

public class ParticleInstructions {
    private final SceneBuilder scene;

    public ParticleInstructions(SceneBuilder scene) {
        this.scene = scene;
    }

    public ParticleDataBuilder<?, ?> simple(int ticks, class_2396<?> type, class_243 pos) {
        if (type instanceof class_2400) {
            class_2400 simple = (class_2400)type;
            return this.create(ticks, pos, new ParticleDataBuilder.Static((class_2394)simple));
        }
        throw new IllegalArgumentException("Particle type " + (Comparable)((Object)(type == null ? "INVALID" : PonderPlatform.getParticleTypeName(type))) + " is null or not simple.");
    }

    public ParticleDataBuilder.DustParticleDataBuilder dust(int ticks, Color color, class_243 pos) {
        return this.create(ticks, pos, new ParticleDataBuilder.DustParticleDataBuilder(color, null).color(color));
    }

    public ParticleDataBuilder.DustParticleDataBuilder dust(int ticks, Color fromColor, Color toColor, class_243 pos) {
        return this.create(ticks, pos, new ParticleDataBuilder.DustParticleDataBuilder(fromColor, toColor).color(fromColor));
    }

    public ParticleDataBuilder.Static item(int ticks, class_1799 item, class_243 pos) {
        class_2392 options = new class_2392(class_2398.field_11218, item);
        return this.create(ticks, pos, new ParticleDataBuilder.Static((class_2394)options));
    }

    public ParticleDataBuilder.Static block(int ticks, class_2680 blockState, class_243 pos) {
        class_2388 options = new class_2388(class_2398.field_11217, blockState);
        return this.create(ticks, pos, new ParticleDataBuilder.Static((class_2394)options));
    }

    public ParticleDataBuilder<?, ?> fluid(int ticks, FluidStackJS fluid, class_243 pos) {
        FluidParticleData data = PonderPlatform.createFluidParticleData(fluid, AllParticleTypes.FLUID_PARTICLE.get());
        return this.create(ticks, pos, new ParticleDataBuilder.Static((class_2394)data));
    }

    public ParticleDataBuilder<?, ?> drip(int ticks, FluidStackJS fluid, class_243 pos) {
        FluidParticleData data = PonderPlatform.createFluidParticleData(fluid, AllParticleTypes.FLUID_DRIP.get());
        return this.create(ticks, pos, new ParticleDataBuilder.Static((class_2394)data));
    }

    public ParticleDataBuilder<?, ?> basin(int ticks, FluidStackJS fluid, class_243 pos) {
        FluidParticleData data = PonderPlatform.createFluidParticleData(fluid, AllParticleTypes.BASIN_FLUID.get());
        return this.create(ticks, pos, new ParticleDataBuilder.Static((class_2394)data));
    }

    public ParticleDataBuilder<?, ?> rotationIndicator(int ticks, class_243 pos, float radius1, float radius2, class_2350.class_2351 axis) {
        return this.create(ticks, pos, new ParticleDataBuilder.RotationIndicatorParticleDataBuilder(radius1, radius2, axis));
    }

    private <O extends ParticleDataBuilder<O, ?>> O create(int ticks, class_243 origin, O options) {
        this.scene.addInstruction((PonderInstruction)new ParticleInstruction(ticks, origin, options));
        return options;
    }

    public static class ParticleInstruction
    extends TickingInstruction {
        private final ParticleDataBuilder<?, ?> builder;
        private final class_243 origin;
        private final List<ParticleTransformation> transformations = new ArrayList<ParticleTransformation>();
        private class_2394 cachedOptions;

        public ParticleInstruction(int ticks, class_243 origin, ParticleDataBuilder<?, ?> builder) {
            super(false, ticks);
            this.origin = origin;
            this.builder = builder;
        }

        protected void firstTick(PonderScene scene) {
            this.cachedOptions = this.builder.createOptions();
            this.transformations.clear();
            this.transformations.addAll(this.builder.transformations);
        }

        public void tick(PonderScene scene) {
            try {
                super.tick(scene);
                this.doTick(scene);
            }
            catch (Exception e) {
                PonderErrorHelper.yeet(e);
                this.remainingTicks = 0;
            }
        }

        private void doTick(PonderScene scene) {
            int currentTick = this.totalTicks - this.remainingTicks;
            for (int i = 0; i < this.builder.density; ++i) {
                ParticleTransformation.Data data = new ParticleTransformation.Data(this.origin, class_243.field_1353);
                for (ParticleTransformation transformation : this.transformations) {
                    float partialTicks = (float)currentTick + (float)i / (float)this.builder.density;
                    data = transformation.apply(partialTicks, data.position(), data.motion());
                }
                class_243 pos = data.position();
                class_243 motion = data.motion();
                class_703 particle = ((PonderWorldAccessor)scene.getWorld()).ponderjs$makeParticle(this.cachedOptions, pos.field_1352, pos.field_1351, pos.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
                if (particle == null) continue;
                this.applyParticleData(particle);
                scene.getWorld().addParticle(particle);
            }
        }

        private void applyParticleData(class_703 particle) {
            if (particle instanceof ParticleAccessor) {
                ParticleAccessor accessor = (ParticleAccessor)particle;
                if (this.builder.color != null) {
                    long argb = this.builder.color.getArgbJS();
                    float a = (float)(argb >> 24 & 0xFFL) / 255.0f;
                    float r = (float)(argb >> 16 & 0xFFL) / 255.0f;
                    float g = (float)(argb >> 8 & 0xFFL) / 255.0f;
                    float b = (float)(argb & 0xFFL) / 255.0f;
                    particle.method_3084(r, g, b);
                    accessor.ponderjs$setAlpha(a);
                }
                if (this.builder.scale != null) {
                    particle.method_3087(this.builder.scale.floatValue());
                }
                if (this.builder.roll != null) {
                    accessor.ponderjs$setRoll(this.builder.roll.floatValue());
                }
                if (this.builder.friction != null) {
                    accessor.ponderjs$setFriction(this.builder.friction.floatValue());
                }
                if (this.builder.gravity != null) {
                    accessor.ponderjs$setGravity(this.builder.gravity.floatValue());
                }
                if (this.builder.physics != null) {
                    accessor.ponderjs$setHasPhysics(this.builder.physics);
                }
                if (this.builder.collision != null) {
                    accessor.ponderjs$setStoppedByCollision(this.builder.collision);
                }
                if (this.builder.lifetime != null) {
                    accessor.ponderjs$setLifetime(this.builder.lifetime);
                }
            }
        }
    }
}

