/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network.client;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.type.ICraftingProvider;
import top.theillusivec4.polymorph.common.network.NetworkManager;
import top.theillusivec4.polymorph.common.network.server.SPacketSyncOutput;

public class CPacketSetCraftingRecipe {
    private final String recipe;

    public CPacketSetCraftingRecipe(String recipe) {
        this.recipe = recipe;
    }

    public static void encode(CPacketSetCraftingRecipe msg, PacketBuffer buf) {
        buf.func_180714_a(msg.recipe);
    }

    public static CPacketSetCraftingRecipe decode(PacketBuffer buf) {
        return new CPacketSetCraftingRecipe(buf.func_150789_c(Short.MAX_VALUE));
    }

    public static void handle(CPacketSetCraftingRecipe msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                Container container = sender.field_71070_bA;
                AtomicReference<ItemStack> output = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
                PolymorphApi.getInstance().getProvider(container).ifPresent(provider -> {
                    if (provider instanceof ICraftingProvider) {
                        ICraftingProvider craftingProvider = (ICraftingProvider)provider;
                        Slot slot = provider.getOutputSlot();
                        Optional result = sender.func_71121_q().func_199532_z().func_215367_a(new ResourceLocation(msg.recipe));
                        CraftingInventory craftingInventory = (CraftingInventory)craftingProvider.getInventory();
                        result.ifPresent(res -> {
                            ICraftingRecipe craftingRecipe;
                            if (res instanceof ICraftingRecipe && (craftingRecipe = (ICraftingRecipe)res).func_77569_a((IInventory)craftingInventory, sender.field_70170_p)) {
                                ItemStack craftResult = craftingRecipe.func_77572_b((IInventory)craftingInventory);
                                output.set(craftResult);
                                slot.field_75224_c.func_70299_a(slot.getSlotIndex(), craftResult);
                            }
                        });
                        ItemStack outputStack = (ItemStack)output.get();
                        if (!outputStack.func_190926_b()) {
                            NetworkManager.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new SPacketSyncOutput(outputStack));
                        }
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

