/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.client.selector;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import top.theillusivec4.polymorph.api.type.IPolyProvider;
import top.theillusivec4.polymorph.api.type.IRecipeSelector;
import top.theillusivec4.polymorph.client.gui.RecipeSelectorGui;
import top.theillusivec4.polymorph.client.gui.ToggleRecipeButton;
import top.theillusivec4.polymorph.common.network.NetworkManager;
import top.theillusivec4.polymorph.common.network.client.CPacketFetchRecipes;

public abstract class RecipeSelector<I extends IInventory, R extends IRecipe<I>>
implements IRecipeSelector<I, R> {
    public static final ResourceLocation TOGGLE = new ResourceLocation("polymorph", "textures/gui/toggle.png");
    private static final int SELECTOR_X_OFFSET = -4;
    private static final int SELECTOR_Y_OFFSET = -26;
    protected final RecipeSelectorGui<I, R> recipeSelectorGui;
    protected final Widget toggleButton;
    protected final IPolyProvider<I, R> provider;
    protected final ContainerScreen<?> parent;
    private boolean updatePosition = false;

    public RecipeSelector(ContainerScreen<?> screen, IPolyProvider<I, R> provider) {
        this.parent = screen;
        this.provider = provider;
        int x = screen.getGuiLeft() + provider.getXPos();
        int y = screen.getGuiTop() + provider.getYPos();
        this.recipeSelectorGui = new RecipeSelectorGui<I, IRecipe>(x + -4, y + -26, provider.getInventory(), this::selectRecipe, (Screen)this.parent);
        this.toggleButton = new ToggleRecipeButton(x, y, 16, 16, 0, 0, 17, TOGGLE, clickWidget -> this.recipeSelectorGui.setVisible(!this.recipeSelectorGui.isVisible()));
        this.toggleButton.field_230694_p_ = this.recipeSelectorGui.getButtons().size() > 1;
    }

    @Override
    public IPolyProvider<I, R> getProvider() {
        return this.provider;
    }

    public void reposition() {
        int x = this.parent.getGuiLeft() + this.provider.getXPos();
        int y = this.parent.getGuiTop() + this.provider.getYPos();
        this.recipeSelectorGui.setPosition(x + -4, y + -26);
        this.toggleButton.field_230690_l_ = x;
        this.toggleButton.field_230691_m_ = y;
    }

    @Override
    public void tick() {
        if (this.updatePosition) {
            this.updatePosition = false;
            this.reposition();
        }
    }

    public void clearRecipes(World world) {
        this.setRecipes(new ArrayList(), world, false, "");
    }

    protected void fetchRecipes() {
        NetworkManager.INSTANCE.sendToServer((Object)new CPacketFetchRecipes());
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.recipeSelectorGui.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.toggleButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.toggleButton.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.recipeSelectorGui.func_231044_a_(mouseX, mouseY, button)) {
            this.recipeSelectorGui.setVisible(false);
            return true;
        }
        if (this.recipeSelectorGui.isVisible()) {
            if (!this.toggleButton.func_231044_a_(mouseX, mouseY, button)) {
                this.recipeSelectorGui.setVisible(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void markUpdatePosition() {
        this.updatePosition = true;
    }

    static class RecipeOutput {
        private final Item item;
        private final int count;
        private final CompoundNBT tag;

        public RecipeOutput(ItemStack stack) {
            this.item = stack.func_77973_b();
            this.count = stack.func_190916_E();
            this.tag = stack.func_77978_p();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecipeOutput that = (RecipeOutput)o;
            return this.count == that.count && this.item.equals(that.item) && Objects.equals(this.tag, that.tag);
        }

        public int hashCode() {
            return Objects.hash(this.item, this.count, this.tag);
        }
    }
}

