/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.geometry;

import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelParser;
import gg.moonflower.pollen.pinwheel.api.common.util.BackgroundLoader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class LocalGeometryModelLoader
implements BackgroundLoader<Map<ResourceLocation, GeometryModel>> {
    private static final Logger LOGGER = LogManager.getLogger();
    static final String FOLDER = "pinwheel/geometry/";

    @Override
    public CompletableFuture<Map<ResourceLocation, GeometryModel>> reload(IResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, GeometryModel> modelLocations = new HashMap<ResourceLocation, GeometryModel>();
            for (ResourceLocation modelLocation : resourceManager.func_199003_a(FOLDER, name -> name.endsWith(".json"))) {
                try {
                    IResource resource = resourceManager.func_199002_a(modelLocation);
                    try {
                        GeometryModelData[] models;
                        for (GeometryModelData model : models = GeometryModelParser.parseModel(IOUtils.toString((InputStream)resource.func_199027_b(), (Charset)StandardCharsets.UTF_8))) {
                            ResourceLocation id = new ResourceLocation(modelLocation.func_110624_b(), model.getDescription().getIdentifier());
                            if (modelLocations.put(id, model.create()) == null) continue;
                            LOGGER.warn("Duplicate geometry model with id '" + id + "'");
                        }
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load geometry file '" + modelLocation.func_110624_b() + ":" + modelLocation.func_110623_a().substring(FOLDER.length(), modelLocation.func_110623_a().length() - 5) + "'", (Throwable)e);
                }
            }
            LOGGER.info("Loaded " + modelLocations.size() + " geometry models.");
            return modelLocations;
        }, backgroundExecutor);
    }
}

