/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.shader;

import com.mojang.blaze3d.systems.RenderSystem;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.ARBComputeShader;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;

public final class ShaderConst {
    private static ShaderMode computeMode;
    private static ShaderMode geometryMode;

    private ShaderConst() {
    }

    @ApiStatus.Internal
    public static void init() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLCapabilities gLCapabilities = GL.getCapabilities();
        computeMode = gLCapabilities.OpenGL43 ? ShaderMode.BASE : (gLCapabilities.GL_ARB_compute_shader ? ShaderMode.ARB : ShaderMode.UNSUPPORTED);
        geometryMode = gLCapabilities.OpenGL32 ? ShaderMode.BASE : (gLCapabilities.GL_ARB_geometry_shader4 ? ShaderMode.ARB : (gLCapabilities.GL_EXT_geometry_shader4 ? ShaderMode.EXT : ShaderMode.UNSUPPORTED));
    }

    public static void glDispatchCompute(int num_groups_x, int num_groups_y, int num_groups_z) {
        switch (computeMode) {
            default: {
                throw new UnsupportedOperationException("glDispatchCompute is unsupported");
            }
            case BASE: {
                GL43C.glDispatchCompute((int)num_groups_x, (int)num_groups_y, (int)num_groups_z);
                break;
            }
            case ARB: {
                ARBComputeShader.glDispatchCompute((int)num_groups_x, (int)num_groups_y, (int)num_groups_z);
            }
        }
    }

    public static void glDispatchComputeIndirect(long indirect) {
        switch (computeMode) {
            default: {
                throw new UnsupportedOperationException("glDispatchComputeIndirect is unsupported");
            }
            case BASE: {
                GL43C.glDispatchComputeIndirect((long)indirect);
                break;
            }
            case ARB: {
                ARBComputeShader.glDispatchComputeIndirect((long)indirect);
            }
        }
    }

    public static boolean isComputeSupported() {
        return computeMode != ShaderMode.UNSUPPORTED;
    }

    public static boolean isGeometrySupported() {
        return geometryMode != ShaderMode.UNSUPPORTED;
    }

    static enum ShaderMode {
        UNSUPPORTED,
        BASE,
        ARB,
        EXT;

    }
}

