/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.geometry;

import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.registry.resource.ResourceRegistry;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.common.util.BackgroundLoader;
import gg.moonflower.pollen.pinwheel.core.client.geometry.DeprecatedLocalGeometryModelLoader;
import gg.moonflower.pollen.pinwheel.core.client.geometry.LocalGeometryModelLoader;
import gg.moonflower.pollen.pinwheel.core.client.util.DynamicReloader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public final class GeometryModelManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Reloader RELOADER = new Reloader();
    private static final DynamicReloader DYNAMIC_RELOADER = new DynamicReloader();
    private static final Set<BackgroundLoader<Map<ResourceLocation, GeometryModel>>> LOADERS = new HashSet<BackgroundLoader<Map<ResourceLocation, GeometryModel>>>();
    private static final Map<ResourceLocation, GeometryModel> MODELS = new HashMap<ResourceLocation, GeometryModel>();

    @ApiStatus.Internal
    public static void init() {
        ResourceRegistry.registerReloadListener(ResourcePackType.CLIENT_RESOURCES, RELOADER);
        GeometryModelManager.addLoader(new DeprecatedLocalGeometryModelLoader());
        GeometryModelManager.addLoader(new LocalGeometryModelLoader());
    }

    public static void addLoader(BackgroundLoader<Map<ResourceLocation, GeometryModel>> loader) {
        LOADERS.add(loader);
    }

    public static CompletableFuture<Unit> reload(boolean showLoadingScreen) {
        return DYNAMIC_RELOADER.reload(showLoadingScreen);
    }

    public static GeometryModel getModel(ResourceLocation location) {
        return MODELS.computeIfAbsent(location, key -> {
            LOGGER.warn("Unknown geometry model with key '{}'", (Object)location);
            return GeometryModel.EMPTY;
        });
    }

    public static boolean isReloading() {
        return DYNAMIC_RELOADER.isReloading();
    }

    static {
        DYNAMIC_RELOADER.addListener(RELOADER);
    }

    private static class Reloader
    implements PollinatedPreparableReloadListener {
        private Reloader() {
        }

        public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            HashMap geometryModels = new HashMap();
            return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])LOADERS.stream().map(modelLoader -> modelLoader.reload(resourceManager, backgroundExecutor, gameExecutor).thenAcceptAsync(pairs -> {
                for (Map.Entry entry : pairs.entrySet()) {
                    if (geometryModels.put((ResourceLocation)entry.getKey(), (GeometryModel)entry.getValue()) == null) continue;
                    LOGGER.warn("Duplicate geometry model: " + entry.getKey());
                }
            }, gameExecutor)).toArray(CompletableFuture[]::new)).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).thenRunAsync(() -> {
                LOGGER.info("Loaded " + geometryModels.size() + " geometry models.");
                MODELS.clear();
                MODELS.putAll(geometryModels);
            }, gameExecutor);
        }

        @Override
        public ResourceLocation getPollenId() {
            return new ResourceLocation("pollen", "geometry_model_manager");
        }
    }
}

