/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.blockdata;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;

public class BlockDataKey<T> {
    private final Supplier<T> defaultValue;
    private final Predicate<BlockState> filter;

    private BlockDataKey(Supplier<T> defaultValue, Predicate<BlockState> filter) {
        this.defaultValue = defaultValue;
        this.filter = filter;
    }

    public Supplier<T> getDefault() {
        return this.defaultValue;
    }

    public Predicate<BlockState> getFilter() {
        return this.filter;
    }

    public static <T> Builder<T> of(Supplier<T> defaultValue) {
        return new Builder(defaultValue);
    }

    public static class Builder<T> {
        private final Supplier<T> defaultValue;
        private Predicate<BlockState> filter;

        private Builder(Supplier<T> defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Builder<T> setFilter(Predicate<BlockState> filter) {
            this.filter = filter;
            return this;
        }

        public Builder<T> setBlocks(Block ... blocks) {
            this.filter = state -> {
                for (Block block : blocks) {
                    if (!state.func_177230_c().func_235332_a_(block)) continue;
                    return true;
                }
                return false;
            };
            return this;
        }

        public BlockDataKey<T> build() {
            return new BlockDataKey(this.defaultValue, this.filter != null ? this.filter : state -> true);
        }
    }
}

