/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.animation;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gg.moonflower.pollen.molangcompiler.api.MolangRuntime;
import gg.moonflower.pollen.molangcompiler.api.bridge.MolangVariableProvider;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedModel;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimationManager;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelManager;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelRenderer;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.jetbrains.annotations.Nullable;

public class AnimatedGeometryEntityModel<T extends Entity>
extends EntityModel<T> {
    private final ResourceLocation model;
    private ResourceLocation texture;
    private ResourceLocation[] animations;
    private float[] animationWeights;
    private MolangVariableProvider variableProvider;

    public AnimatedGeometryEntityModel(ResourceLocation model) {
        this.model = model;
        this.texture = null;
        this.animations = new ResourceLocation[0];
        this.animationWeights = new float[0];
        this.variableProvider = null;
    }

    private MolangRuntime.Builder createRuntime(T entity, float limbSwing, float limbSwingAmount, float yaw, float pitch) {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        MolangRuntime.Builder builder = MolangRuntime.runtime();
        if (((Entity)entity).field_70170_p instanceof ClientWorld) {
            builder.setQuery("actor_count", () -> Float.valueOf(((ClientWorld)entity.field_70170_p).func_217425_f()));
        }
        builder.setQuery("time_of_day", () -> Float.valueOf(entity.field_70170_p.func_242415_f(partialTicks) / 24000.0f));
        builder.setQuery("day", () -> Float.valueOf(entity.field_70170_p.func_72820_D() / 24000L + 1L));
        builder.setQuery("moon_phase", () -> Float.valueOf(entity.field_70170_p.func_242414_af()));
        builder.setQuery("moon_brightness", () -> Float.valueOf(entity.field_70170_p.func_242413_ae()));
        builder.setQuery("is_on_ground", entity.func_233570_aj_() ? 1.0f : 0.0f);
        builder.setQuery("is_in_water", entity.func_70090_H() ? 1.0f : 0.0f);
        builder.setQuery("is_in_water_or_rain", entity.func_70026_G() ? 1.0f : 0.0f);
        builder.setQuery("is_in_contact_with_water", entity.func_203008_ap() ? 1.0f : 0.0f);
        builder.setQuery("is_moving", () -> Float.valueOf(entity.func_213322_ci().func_189985_c() > 1.0E-7 ? 1.0f : 0.0f));
        builder.setQuery("is_alive", entity.func_70089_S() ? 1.0f : 0.0f);
        builder.setQuery("is_fire_immune", entity.func_230279_az_() ? 1.0f : 0.0f);
        builder.setQuery("is_on_fire", entity.func_70027_ad() ? 1.0f : 0.0f);
        builder.setQuery("is_first_person", entity == Minecraft.func_71410_x().func_175606_aa() && Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON ? 1.0f : 0.0f);
        builder.setQuery("is_invisible", entity.func_82150_aj() ? 1.0f : 0.0f);
        builder.setQuery("is_ghost", entity.func_175149_v() ? 1.0f : 0.0f);
        builder.setQuery("ground_speed", () -> {
            Vector3d velocity = entity.func_213322_ci();
            return Float.valueOf(MathHelper.func_76129_c((float)((float)(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c))));
        });
        if (entity instanceof LivingEntity) {
            builder.setQuery("modified_move_speed", ((LivingEntity)entity).func_70689_ay());
        }
        builder.setQuery("modified_distance_moved", ((Entity)entity).field_82151_R);
        builder.setQuery("vertical_speed", (float)entity.func_213322_ci().func_82617_b());
        builder.setQuery("head_x_rotation", pitch);
        builder.setQuery("head_y_rotation", yaw);
        if (entity instanceof LivingEntity) {
            builder.setQuery("body_y_rotation", () -> Float.valueOf(MathHelper.func_219799_g((float)partialTicks, (float)((LivingEntity)entity).field_70760_ar, (float)((LivingEntity)entity).field_70761_aq)));
        }
        builder.setQuery("head_x_rotation_speed", () -> Float.valueOf(entity.func_195050_f(partialTicks) - entity.func_195050_f((float)((double)partialTicks - 0.1))));
        builder.setQuery("head_y_rotation_speed", () -> Float.valueOf(entity.func_195046_g(partialTicks) - entity.func_195046_g((float)((double)partialTicks - 0.1))));
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            builder.setQuery("health", livingEntity.func_110143_aJ());
            builder.setQuery("max_health", livingEntity.func_110138_aP());
            builder.setQuery("is_baby", livingEntity.func_70631_g_() ? 1.0f : 0.0f);
        }
        builder.setQuery("distance_from_camera", () -> Float.valueOf((float)Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c().func_72438_d(entity.func_213303_ch())));
        builder.setQuery("camera_distance_range_lerp", 2, context -> {
            float second;
            float first = context.resolve(0);
            if (first == (second = context.resolve(1))) {
                return 1.0f;
            }
            float smaller = Math.min(first, second);
            float larger = Math.max(first, second);
            double distance = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c().func_72438_d(entity.func_213303_ch());
            if (distance <= (double)smaller) {
                return smaller;
            }
            if (distance >= (double)larger) {
                return larger;
            }
            return (float)((distance - (double)smaller) / (double)(larger - smaller));
        });
        builder.setQuery("lod_index", -1, context -> {
            if (context.getParameters() <= 0) {
                return 0.0f;
            }
            double distance = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c().func_72438_d(entity.func_213303_ch());
            for (int i = 0; i < context.getParameters(); ++i) {
                if (!(distance < (double)context.resolve(0))) continue;
                return i;
            }
            return context.getParameters() - 1;
        });
        builder.setQuery("position", 1, context -> {
            int index = (int)context.resolve(0);
            if (index < 0 || index >= 3) {
                throw new MolangException("Invalid argument for position(): " + index);
            }
            return (float)(index == 0 ? entity.func_226275_c_((double)partialTicks) : (index == 1 ? entity.func_226283_e_((double)partialTicks) : entity.func_226285_f_((double)partialTicks)));
        });
        builder.setQuery("position_delta", 1, context -> {
            int index = (int)context.resolve(0);
            if (index < 0 || index >= 3) {
                throw new MolangException("Invalid argument for position(): " + index);
            }
            return (float)(index == 0 ? entity.func_213322_ci().func_82615_a() : (index == 1 ? entity.func_213322_ci().func_82617_b() : entity.func_213322_ci().func_82616_c()));
        });
        builder.setQuery("limb_swing", limbSwing);
        builder.setQuery("limb_swing_amount", limbSwingAmount);
        return builder;
    }

    public void func_225597_a_(T entity, float limbSwing, float limbSwingAmount, float animationTicks, float netHeadYaw, float headPitch) {
        GeometryModel model = this.getModel();
        model.resetTransformation();
        if (model instanceof AnimatedModel && this.animations.length > 0) {
            AnimationData[] animationData = this.getAnimations();
            if (animationData.length == 0) {
                return;
            }
            IProfiler profiler = Minecraft.func_71410_x().func_213239_aq();
            profiler.func_76320_a("createMolangRuntime");
            MolangRuntime.Builder builder = this.createRuntime(entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch);
            if (entity instanceof MolangVariableProvider) {
                builder.setVariables((MolangVariableProvider)entity);
            }
            if (this.variableProvider != null) {
                builder.setVariables(this.variableProvider);
            }
            profiler.func_219895_b("applyMolangAnimation");
            ((AnimatedModel)((Object)model)).applyAnimations(animationTicks / 20.0f, builder, this.animationWeights, animationData);
            profiler.func_76319_b();
        }
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.renderToBuffer(matrixStack, (IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_(), packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderToBuffer(MatrixStack matrixStack, IRenderTypeBuffer source, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)1.501f, 0.0);
        GeometryModelRenderer.render(this.getModel(), this.texture, source, matrixStack, packedLight, packedOverlay, red, green, blue, alpha);
        matrixStack.func_227865_b_();
    }

    public GeometryModel getModel() {
        return GeometryModelManager.getModel(this.model);
    }

    @Nullable
    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(@Nullable ResourceLocation texture) {
        this.texture = texture;
    }

    public ResourceLocation[] getAnimationNames() {
        return this.animations;
    }

    public AnimationData[] getAnimations() {
        return (AnimationData[])Arrays.stream(this.animations).map(AnimationManager::getAnimation).filter(animation -> animation != AnimationData.EMPTY).toArray(AnimationData[]::new);
    }

    public void setAnimations(ResourceLocation ... animations) {
        this.animations = animations;
    }

    public void setAnimationWeights(float[] animationWeights) {
        this.animationWeights = animationWeights;
    }

    public void setVariableProvider(@Nullable MolangVariableProvider variableProvider) {
        this.variableProvider = variableProvider;
    }
}

