/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.molangcompiler.core.node;

import gg.moonflower.pollen.molangcompiler.api.MolangEnvironment;
import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import gg.moonflower.pollen.molangcompiler.api.object.MolangObject;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MolangInvokeFunctionNode
implements MolangExpression {
    private final String object;
    private final String name;
    private final MolangExpression[] parameters;

    public MolangInvokeFunctionNode(String object, String name, MolangExpression ... parameters) {
        this.object = object;
        this.name = name;
        this.parameters = parameters;
    }

    @Override
    public float resolve(MolangEnvironment environment) throws MolangException {
        MolangExpression function;
        MolangObject object = environment.get(this.object);
        if (object.has(this.name + "$" + this.parameters.length)) {
            function = object.get(this.name + "$" + this.parameters.length);
        } else if (object.has(this.name)) {
            function = object.get(this.name);
        } else {
            throw new IllegalStateException("Unknown function: " + this.object + "." + this.name + "() with " + this.parameters.length + " parameters");
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            environment.loadParameter(i, this.parameters[i]);
        }
        float result = function.resolve(environment);
        environment.clearParameters();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.object).append('.').append(this.name).append('(');
        for (int i = 0; i < this.parameters.length; ++i) {
            builder.append(this.parameters[i].toString());
            if (i >= this.parameters.length - 1) continue;
            builder.append(", ");
        }
        return builder.append(')').toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MolangInvokeFunctionNode that = (MolangInvokeFunctionNode)o;
        return this.object.equals(that.object) && this.name.equals(that.name) && Arrays.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = Objects.hash(this.object, this.name);
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }
}

