/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.molangcompiler.core.node;

import gg.moonflower.pollen.molangcompiler.api.MolangEnvironment;
import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MolangCompoundNode
implements MolangExpression {
    private final MolangExpression[] expressions;

    public MolangCompoundNode(MolangExpression ... expressions) {
        this.expressions = expressions;
    }

    @Override
    public float resolve(MolangEnvironment environment) throws MolangException {
        for (int i = 0; i < this.expressions.length; ++i) {
            float result = this.expressions[i].resolve(environment);
            if (i < this.expressions.length - 1) continue;
            return result;
        }
        return 0.0f;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.expressions.length; ++i) {
            if (i >= this.expressions.length - 1) {
                builder.append("return ");
            }
            builder.append(this.expressions[i]);
            builder.append(';');
            if (i >= this.expressions.length - 1) continue;
            builder.append('\n');
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MolangCompoundNode that = (MolangCompoundNode)o;
        return Arrays.equals(this.expressions, that.expressions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.expressions);
    }
}

