/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.molangcompiler.api.object;

import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import gg.moonflower.pollen.molangcompiler.api.object.MolangObject;
import gg.moonflower.pollen.molangcompiler.core.object.MolangFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class MolangLibrary
implements MolangObject {
    private final Map<String, MolangExpression> functions = new HashMap<String, MolangExpression>();

    public MolangLibrary() {
        this.populate(this.functions::put);
    }

    protected abstract void populate(BiConsumer<String, MolangExpression> var1);

    protected abstract String getName();

    @Override
    public void set(String name, MolangExpression value) {
        throw new UnsupportedOperationException("Cannot set values on a library");
    }

    @Override
    public MolangExpression get(String name) {
        return this.functions.getOrDefault(name, MolangExpression.ZERO);
    }

    @Override
    public boolean has(String name) {
        return this.functions.containsKey(name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getName()).append('\n');
        for (Map.Entry<String, MolangExpression> entry : this.functions.entrySet()) {
            builder.append('\t').append(entry.getKey());
            if (entry.getValue() instanceof MolangFunction) {
                builder.append("()");
            }
            builder.append('\n');
        }
        return builder.toString();
    }
}

