/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.network.forge;

import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import gg.moonflower.pollen.api.sync.forge.SyncedDataManagerImpl;
import gg.moonflower.pollen.core.network.forge.ForgeClientPlayPacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClientboundUpdateSyncedDataPacket
implements PollinatedPacket<ForgeClientPlayPacketHandler> {
    private Entity provider;
    private Entity player;
    private boolean sync;
    @OnlyIn(value=Dist.CLIENT)
    private int entityId;
    @OnlyIn(value=Dist.CLIENT)
    private PacketBuffer payload;

    public ClientboundUpdateSyncedDataPacket(Entity provider, Entity player, boolean sync) {
        this.provider = provider;
        this.player = player;
        this.sync = sync;
    }

    public ClientboundUpdateSyncedDataPacket(PacketBuffer buf) {
        this.entityId = buf.func_150792_a();
        this.payload = buf;
    }

    @Override
    public void writePacketData(PacketBuffer buf) {
        buf.func_150787_b(this.provider.func_145782_y());
        SyncedDataManagerImpl.writePacketData(buf, this.provider, this.player, this.sync);
    }

    @Override
    public void processPacket(ForgeClientPlayPacketHandler handler, PollinatedPacketContext ctx) {
        handler.handleClientboundUpdateSyncedDataPacket(this, ctx);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEntityId() {
        return this.entityId;
    }

    @OnlyIn(value=Dist.CLIENT)
    public PacketBuffer getPayload() {
        return this.payload;
    }
}

