/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin.client;

import com.mojang.authlib.GameProfile;
import gg.moonflower.pollen.api.fluid.PollenFluidBehavior;
import gg.moonflower.pollen.api.registry.FluidBehaviorRegistry;
import gg.moonflower.pollen.core.client.sound.CustomLiquidSoundInstance;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraft.util.MovementInput;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientPlayerEntity.class})
public abstract class LocalPlayerMixin
extends PlayerEntity {
    @Shadow
    @Final
    protected Minecraft field_71159_c;
    @Shadow
    public MovementInput field_71158_b;
    @Unique
    private final Set<ITag<Fluid>> wasInFluids = new HashSet<ITag<Fluid>>();

    @Shadow
    public abstract void func_70031_b(boolean var1);

    private LocalPlayerMixin(World level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isFallFlying()Z", shift=At.Shift.BEFORE)})
    public void updateCustomFluidDescent(CallbackInfo ci) {
        if (this.func_70090_H() || !this.field_71158_b.field_228350_h_ || !this.func_241208_cS_()) {
            return;
        }
        if (FluidBehaviorRegistry.getFluids().stream().filter(tag -> this.field_233554_M_.getDouble(tag) > 0.0).anyMatch(tag -> Objects.requireNonNull(FluidBehaviorRegistry.get((ITag<Fluid>)tag)).canDescend(this))) {
            this.func_203010_cG();
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;setSprinting(Z)V", ordinal=1, shift=At.Shift.AFTER)})
    public void updateCustomFluidSprint(CallbackInfo ci) {
        if (this.func_70051_ag() && FluidBehaviorRegistry.getFluids().stream().filter(tag -> this.field_233554_M_.getDouble(tag) > 0.0).anyMatch(tag -> !Objects.requireNonNull(FluidBehaviorRegistry.get((ITag<Fluid>)tag)).canSprint(this))) {
            this.func_70031_b(false);
        }
    }

    @Inject(method={"updateIsUnderwater"}, at={@At(value="TAIL")})
    public void updateCustomFluidSounds(CallbackInfoReturnable<Boolean> cir) {
        FluidBehaviorRegistry.getFluids().forEach(tag -> {
            SoundEvent ambientExit;
            PollenFluidBehavior behavior = Objects.requireNonNull(FluidBehaviorRegistry.get((ITag<Fluid>)tag));
            boolean bl = this.wasInFluids.contains(tag);
            boolean bl2 = this.func_208600_a((ITag)tag);
            if (bl2) {
                this.wasInFluids.add((ITag<Fluid>)tag);
            } else {
                this.wasInFluids.remove(tag);
            }
            if (!bl && bl2) {
                SoundEvent ambientEnter = behavior.getAmbientEnter(this);
                SoundEvent ambientLoop = behavior.getAmbientLoop(this);
                if (ambientEnter != null) {
                    this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ambientEnter, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                }
                if (ambientLoop != null) {
                    this.field_71159_c.func_147118_V().func_147682_a((ISound)new CustomLiquidSoundInstance((ClientPlayerEntity)this, (ITag<Fluid>)tag, ambientLoop));
                }
            }
            if (bl && !bl2 && (ambientExit = behavior.getAmbientExit(this)) != null) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ambientExit, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
            }
        });
    }
}

