/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin;

import gg.moonflower.pollen.api.event.events.entity.ModifyGravityEvent;
import gg.moonflower.pollen.api.event.events.lifecycle.TickEvents;
import gg.moonflower.pollen.api.fluid.PollenFluidBehavior;
import gg.moonflower.pollen.api.registry.FluidBehaviorRegistry;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectUtils;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private int captureAirSupply;

    @Shadow
    protected abstract int func_70682_h(int var1);

    @Shadow
    public abstract boolean func_70648_aU();

    @Shadow
    public abstract void func_233629_a_(LivingEntity var1, boolean var2);

    @Shadow
    protected abstract boolean func_241208_cS_();

    @Shadow
    public abstract boolean func_230285_a_(Fluid var1);

    private LivingEntityMixin(EntityType<? extends Entity> entityType, World level) {
        super(entityType, level);
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    public void captureState(CallbackInfo ci) {
        this.captureAirSupply = this.func_70086_ai();
    }

    @Inject(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWaterRainOrBubble()Z", shift=At.Shift.BEFORE)})
    public void tickFluidDrowning(CallbackInfo ci) {
        if (this.func_70089_S()) {
            PollenFluidBehavior behavior;
            PollenFluidBehavior pollenFluidBehavior = behavior = this.field_241335_O_ != null ? FluidBehaviorRegistry.get((ITag<Fluid>)this.field_241335_O_) : null;
            if (behavior == null) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)this;
            if (!behavior.shouldEntityDrown(livingEntity)) {
                return;
            }
            if (!(this.func_70648_aU() || EffectUtils.func_205133_c((LivingEntity)livingEntity) || this instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75102_a)) {
                this.func_70050_g(this.captureAirSupply);
                this.func_70050_g(this.func_70682_h(this.func_70086_ai()));
                if (this.func_70086_ai() == -20) {
                    this.func_70050_g(0);
                    Vector3d vec3 = this.func_213322_ci();
                    IParticleData particle = behavior.getDrowningParticles(livingEntity);
                    if (particle != null) {
                        for (int i = 0; i < 8; ++i) {
                            double f = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            double g = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            double h = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            this.field_70170_p.func_195594_a(particle, this.func_226277_ct_() + f, this.func_226278_cu_() + g, this.func_226281_cx_() + h, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
                        }
                    }
                    this.func_70097_a(DamageSource.field_76369_e, behavior.getDrowningDamage(livingEntity));
                }
            }
            if (!this.field_70170_p.func_201670_d() && this.func_184218_aH() && this.func_184187_bx() != null && !behavior.canVehicleTraverse(livingEntity, this.func_184187_bx())) {
                this.func_184210_p();
            }
        }
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    public void updateCustomFluid(double y, boolean onGround, BlockState state, BlockPos pos, CallbackInfo ci) {
        FluidBehaviorRegistry.getFluids().stream().filter(tag -> this.func_233571_b_((ITag)tag) == 0.0).forEach(tag -> FluidBehaviorRegistry.doFluidPushing((ITag<Fluid>)tag, this));
    }

    @ModifyVariable(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getFluidJumpThreshold()D", shift=At.Shift.BEFORE), ordinal=0)
    public boolean modifyInWater(boolean value) {
        return value || FluidBehaviorRegistry.getFluids().stream().anyMatch(tag -> this.func_233571_b_((ITag)tag) > 0.0);
    }

    @Inject(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    public void travelInCustomFluid(Vector3d travelVector, CallbackInfo ci, double fallSpeed) {
        if (this.func_241208_cS_() && !this.func_230285_a_(this.field_70170_p.func_204610_c(this.func_233580_cy_()).func_206886_c())) {
            FluidBehaviorRegistry.getFluids().stream().filter(tag -> this.func_233571_b_((ITag)tag) > 0.0).forEach(tag -> {
                PollenFluidBehavior behavior = Objects.requireNonNull(FluidBehaviorRegistry.get((ITag<Fluid>)tag));
                behavior.applyPhysics((LivingEntity)this, travelVector, fallSpeed, this.func_213322_ci().field_72448_b <= 0.0);
                ci.cancel();
            });
            if (ci.isCancelled()) {
                this.func_233629_a_((LivingEntity)this, this instanceof IFlyingAnimal);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        TickEvents.LIVING_POST.invoker().tick((LivingEntity)this);
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;", shift=At.Shift.BEFORE))
    public double modifyGravity(double gravity) {
        return ModifyGravityEvent.EVENT.invoker().modifyGravity((LivingEntity)this, gravity);
    }
}

