/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.entitlement.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gg.moonflower.pollen.core.client.entitlement.Entitlement;
import gg.moonflower.pollen.core.client.entitlement.RenderableCosmetic;
import gg.moonflower.pollen.core.client.entitlement.type.SimpleCosmetic;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ModelCosmetic
extends SimpleCosmetic
implements RenderableCosmetic {
    public static final Codec<ModelCosmetic> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("modelUrl").forGetter(cosmetic -> cosmetic.getModelUrls()[0]), (App)Codec.STRING.fieldOf("modelKey").forGetter(cosmetic -> Objects.requireNonNull(cosmetic.getModelKey()).func_110623_a()), (App)GeometryModelTextureTable.CODEC.fieldOf("textureTable").forGetter(ModelCosmetic::getTextureTable)).apply((Applicative)instance, ModelCosmetic::new));
    private final String[] modelUrl;
    private final ResourceLocation modelKey;
    private final GeometryModelTextureTable textureTable;

    public ModelCosmetic(String modelUrl, String modelKey, GeometryModelTextureTable textureTable) {
        this.modelUrl = new String[]{modelUrl};
        this.modelKey = new ResourceLocation("pollen", modelKey);
        this.textureTable = textureTable;
    }

    @Override
    protected Entitlement copyData() {
        return new ModelCosmetic(this.modelUrl[0], this.modelKey.func_110623_a(), this.textureTable);
    }

    @Override
    public Entitlement.Type getType() {
        return Entitlement.Type.COSMETIC;
    }

    @Override
    public void registerTextures(BiConsumer<ResourceLocation, GeometryModelTextureTable> textureConsumer) {
        textureConsumer.accept(this.getRegistryName(), this.textureTable);
    }

    @Override
    public ResourceLocation getTextureKey() {
        return this.getRegistryName();
    }

    @Override
    public String[] getModelUrls() {
        return this.modelUrl;
    }

    @Override
    public ResourceLocation getModelKey() {
        return this.modelKey;
    }

    public GeometryModelTextureTable getTextureTable() {
        return this.textureTable;
    }
}

