/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.condition;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.api.resource.condition.PollinatedResourceConditionProvider;
import gg.moonflower.pollen.api.resource.condition.forge.PollinatedResourceConditionImpl;
import gg.moonflower.pollen.api.util.NumberCompareMode;
import gg.moonflower.pollen.core.resource.condition.ConfigResourceCondition;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

public interface PollinatedResourceCondition {
    public boolean test(JsonObject var1) throws JsonParseException;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider and(PollinatedResourceConditionProvider ... values) {
        return PollinatedResourceConditionImpl.and(values);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider FALSE() {
        return PollinatedResourceConditionImpl.FALSE();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider TRUE() {
        return PollinatedResourceConditionImpl.TRUE();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider not(PollinatedResourceConditionProvider value) {
        return PollinatedResourceConditionImpl.not(value);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider or(PollinatedResourceConditionProvider ... values) {
        return PollinatedResourceConditionImpl.or(values);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider blockExists(ResourceLocation name) {
        return PollinatedResourceConditionImpl.blockExists(name);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider itemExists(ResourceLocation name) {
        return PollinatedResourceConditionImpl.itemExists(name);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider fluidExists(ResourceLocation name) {
        return PollinatedResourceConditionImpl.fluidExists(name);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider itemTagPopulated(ITag.INamedTag<Item> tag) {
        return PollinatedResourceConditionImpl.itemTagPopulated(tag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider blockTagPopulated(ITag.INamedTag<Block> tag) {
        return PollinatedResourceConditionImpl.blockTagPopulated(tag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider fluidTagPopulated(ITag.INamedTag<Fluid> tag) {
        return PollinatedResourceConditionImpl.fluidTagPopulated(tag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider allModsLoaded(String ... modIds) {
        return PollinatedResourceConditionImpl.allModsLoaded(modIds);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PollinatedResourceConditionProvider anyModsLoaded(String ... modIds) {
        return PollinatedResourceConditionImpl.anyModsLoaded(modIds);
    }

    public static PollinatedResourceConditionProvider config(String modId, PollinatedConfigType type, String key, Object value) {
        return new ConfigResourceCondition.SimpleProvider(modId, type, key, value);
    }

    public static PollinatedResourceConditionProvider config(String modId, PollinatedConfigType type, String key, Number value, NumberCompareMode compareMode) {
        return new ConfigResourceCondition.NumberProvider(modId, type, key, value, compareMode);
    }
}

