/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry.forge;

import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.resource.condition.PollinatedResourceCondition;
import gg.moonflower.pollen.api.resource.condition.forge.BlockExistsCondition;
import gg.moonflower.pollen.api.resource.condition.forge.BlockTagPopulatedCondition;
import gg.moonflower.pollen.api.resource.condition.forge.FluidExistsCondition;
import gg.moonflower.pollen.api.resource.condition.forge.FluidTagPopulatedCondition;
import gg.moonflower.pollen.api.resource.condition.forge.ItemTagPopulatedCondition;
import gg.moonflower.pollen.api.resource.condition.forge.PollinatedRecipeConditionWrapper;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(modid="pollen", bus=Mod.EventBusSubscriber.Bus.MOD)
@ApiStatus.Internal
public class ResourceConditionRegistryImpl {
    private static final Set<IConditionSerializer<?>> CONDITIONS = ConcurrentHashMap.newKeySet();
    private static final Logger LOGGER = LogManager.getLogger();

    public static void register(ResourceLocation name, PollinatedResourceCondition condition) {
        if (!CONDITIONS.add(new PollinatedRecipeConditionWrapper.Serializer(name, condition))) {
            LOGGER.warn("Duplicate recipe condition with id: " + name);
        }
    }

    @SubscribeEvent
    public static void registerRecipeConditions(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CONDITIONS.forEach(CraftingHelper::register);
        CraftingHelper.register((IConditionSerializer)BlockExistsCondition.Serializer.INSTANCE);
        CraftingHelper.register((IConditionSerializer)FluidExistsCondition.Serializer.INSTANCE);
        CraftingHelper.register((IConditionSerializer)ItemTagPopulatedCondition.Serializer.INSTANCE);
        CraftingHelper.register((IConditionSerializer)BlockTagPopulatedCondition.Serializer.INSTANCE);
        CraftingHelper.register((IConditionSerializer)FluidTagPopulatedCondition.Serializer.INSTANCE);
    }

    public static IConditionSerializer<?> get(PollinatedResourceCondition condition) {
        return CONDITIONS.stream().filter(serializer -> serializer instanceof PollinatedRecipeConditionWrapper.Serializer && ((PollinatedRecipeConditionWrapper.Serializer)serializer).getCondition() == condition).findFirst().orElseThrow(() -> new IllegalStateException("Unregistered condition: " + condition));
    }

    public static boolean test(JsonObject json) {
        return CraftingHelper.processConditions((JsonObject)json, (String)"conditions");
    }

    public static String getConditionsKey() {
        return "conditions";
    }
}

