/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.item;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.injectables.annotations.PlatformOnly;
import gg.moonflower.pollen.api.item.TabFiller;
import gg.moonflower.pollen.api.item.forge.SpawnEggItemBaseImpl;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.content.DispenseItemBehaviorRegistry;
import java.util.function.Supplier;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class SpawnEggItemBase<T extends EntityType<? extends MobEntity>>
extends SpawnEggItem {
    private static final IDispenseItemBehavior DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            EntityType type = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
            try {
                type.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
            }
            catch (Exception var6) {
                LogManager.getLogger().error("Error while dispensing spawn egg from dispenser at {}", (Object)source.func_180699_d(), (Object)var6);
                return ItemStack.field_190927_a;
            }
            stack.func_190918_g(1);
            return stack;
        }
    };
    private final boolean addToMisc;
    private final Supplier<T> type;

    public SpawnEggItemBase(Supplier<T> type, int backgroundColor, int spotColor, Item.Properties builder) {
        this(type, backgroundColor, spotColor, false, builder);
    }

    @Deprecated
    public SpawnEggItemBase(Supplier<T> type, int backgroundColor, int spotColor, boolean addToMisc, Item.Properties builder) {
        super(Platform.isForge() ? null : (EntityType)type.get(), backgroundColor, spotColor, builder);
        this.type = type;
        this.addToMisc = addToMisc;
        if (Platform.isForge()) {
            SpawnEggItemBase.registerSpawnEgg(this, type);
        }
        DispenseItemBehaviorRegistry.register((IItemProvider)this, DISPENSE_BEHAVIOR);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @PlatformOnly(value={"forge"})
    @ExpectPlatform.Transformed
    public static void registerSpawnEgg(SpawnEggItem item, Supplier<? extends EntityType<?>> type) {
        void var1_1;
        SpawnEggItemBaseImpl.registerSpawnEgg(item, var1_1);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) || this.addToMisc && group == ItemGroup.field_78026_f) {
            TabFiller.insertNamed(new ItemStack((IItemProvider)this), false, items, stack -> stack.func_77973_b() instanceof SpawnEggItem);
        }
    }

    public EntityType<?> func_208076_b(@Nullable CompoundNBT nbt) {
        CompoundNBT compoundnbt;
        if (!Platform.isForge()) {
            return super.func_208076_b(nbt);
        }
        if (nbt != null && nbt.func_150297_b("EntityTag", 10) && (compoundnbt = nbt.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return (EntityType)EntityType.func_220327_a((String)compoundnbt.func_74779_i("id")).orElseGet(this.type);
        }
        return (EntityType)this.type.get();
    }
}

