/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.item;

import gg.moonflower.pollen.api.entity.PollinatedBoat;
import gg.moonflower.pollen.api.entity.PollinatedBoatType;
import gg.moonflower.pollen.api.item.TabFiller;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoatItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class PollinatedBoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntityPredicates.field_180132_d.and(Entity::func_70067_L);
    private static final Map<PollinatedBoatType, Item> BOAT_ITEMS = new ConcurrentHashMap<PollinatedBoatType, Item>();
    private static final IDispenseItemBehavior DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            double offset;
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            ServerWorld level = source.func_197524_h();
            double x = source.func_82615_a() + (double)((float)direction.func_82601_c() * 1.125f);
            double y = source.func_82617_b() + (double)((float)direction.func_96559_d() * 1.125f);
            double z = source.func_82616_c() + (double)((float)direction.func_82599_e() * 1.125f);
            BlockPos blockPos = source.func_180699_d().func_177972_a(direction);
            if (level.func_204610_c(blockPos).func_206884_a((ITag)FluidTags.field_206959_a)) {
                offset = 1.0;
            } else {
                if (!level.func_180495_p(blockPos).func_196958_f() || !level.func_204610_c(blockPos.func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    return this.defaultDispenseItemBehavior.dispense(source, stack);
                }
                offset = 0.0;
            }
            PollinatedBoat boat = new PollinatedBoat((World)level, x, y + offset, z);
            boat.setPollenType(((PollinatedBoatItem)stack.func_77973_b()).getType().get());
            boat.field_70177_z = direction.func_185119_l();
            level.func_217376_c((Entity)boat);
            stack.func_190918_g(1);
            return stack;
        }
    };
    private final Supplier<PollinatedBoatType> type;

    public PollinatedBoatItem(Supplier<PollinatedBoatType> type, Item.Properties properties) {
        super(properties);
        this.type = type;
        BOAT_ITEMS.put(type.get(), this);
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)DISPENSE_BEHAVIOR);
    }

    @Nullable
    public static Item getBoatItem(PollinatedBoatType type) {
        return BOAT_ITEMS.get(type);
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand usedHand) {
        ItemStack itemStack = player.func_184586_b(usedHand);
        BlockRayTraceResult hitResult = PollinatedBoatItem.func_219968_a((World)level, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (hitResult.func_216346_c() != RayTraceResult.Type.MISS) {
            Vector3d vec3 = player.func_70676_i(1.0f);
            List list = level.func_175674_a((Entity)player, player.func_174813_aQ().func_216361_a(vec3.func_186678_a(5.0)).func_186662_g(1.0), ENTITY_PREDICATE);
            if (!list.isEmpty()) {
                Vector3d eyePos = player.func_174824_e(1.0f);
                for (Entity entity : list) {
                    AxisAlignedBB box = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                    if (!box.func_72318_a(eyePos)) continue;
                    return ActionResult.func_226250_c_((Object)itemStack);
                }
            }
            if (hitResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                PollinatedBoat boat = new PollinatedBoat(level, hitResult.func_216347_e().field_72450_a, hitResult.func_216347_e().field_72448_b, hitResult.func_216347_e().field_72449_c);
                boat.setPollenType(this.type.get());
                boat.field_70177_z = player.field_70177_z;
                if (!level.func_226665_a__((Entity)boat, boat.func_174813_aQ().func_186662_g(-0.1))) {
                    return ActionResult.func_226251_d_((Object)itemStack);
                }
                if (!level.func_201670_d()) {
                    level.func_217376_c((Entity)boat);
                    if (!player.func_184812_l_()) {
                        itemStack.func_190918_g(1);
                    }
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                return ActionResult.func_233538_a_((Object)itemStack, (boolean)level.func_201670_d());
            }
        }
        return ActionResult.func_226250_c_((Object)itemStack);
    }

    public void func_150895_a(ItemGroup category, NonNullList<ItemStack> items) {
        if (this.func_194125_a(category)) {
            TabFiller.insert(new ItemStack((IItemProvider)this), false, items, stack -> stack.func_77973_b() instanceof BoatItem || stack.func_77973_b() instanceof PollinatedBoatItem);
        }
    }

    public Supplier<PollinatedBoatType> getType() {
        return this.type;
    }
}

