/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider.loot_table;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import gg.moonflower.pollen.api.datagen.provider.loot_table.PollinatedLootGenerator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PollinatedLootTableProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<LootParameterSet, Set<PollinatedLootGenerator>> lootGenerators = new HashMap<LootParameterSet, Set<PollinatedLootGenerator>>();
    private final DataGenerator generator;

    public PollinatedLootTableProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) {
        Path outputFolder = this.generator.func_200391_b();
        HashMap<ResourceLocation, LootTable> lootTables = new HashMap<ResourceLocation, LootTable>();
        this.lootGenerators.forEach((paramSet, lootGenerators) -> {
            BiConsumer<ResourceLocation, LootTable.Builder> registry = (name, builder) -> {
                if (lootTables.put((ResourceLocation)name, builder.func_216039_a(paramSet).func_216038_b()) != null) {
                    throw new IllegalStateException("Duplicate loot table " + name);
                }
            };
            lootGenerators.forEach(generator -> generator.accept(registry));
        });
        ValidationTracker validationContext = new ValidationTracker(LootParameterSets.field_216266_g, resourceLocationx -> null, lootTables::get);
        lootTables.forEach((name, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validationContext, (ResourceLocation)name, (LootTable)lootTable));
        Multimap problems = validationContext.func_227527_a_();
        if (!problems.isEmpty()) {
            problems.forEach((subject, description) -> LOGGER.warn("Found validation problem in " + subject + ": " + description));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        lootTables.forEach((name, lootTable) -> {
            Path path = PollinatedLootTableProvider.createPath(outputFolder, name);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save loot table {}", (Object)path, (Object)e);
            }
        });
    }

    public PollinatedLootTableProvider add(LootParameterSet paramSet, PollinatedLootGenerator generator) {
        this.lootGenerators.computeIfAbsent(paramSet, __ -> new HashSet()).add(generator);
        return this;
    }

    private static Path createPath(Path path, ResourceLocation id) {
        return path.resolve("data/" + id.func_110624_b() + "/loot_tables/" + id.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "LootTables";
    }
}

