/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.datagen.provider.SimpleConditionalDataProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EnterBlockTrigger;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SmithingRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PollinatedRecipeProvider
extends SimpleConditionalDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public PollinatedRecipeProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet set = new HashSet();
        this.buildRecipes(finishedRecipe -> {
            if (!set.add(finishedRecipe.func_200442_b())) {
                throw new IllegalStateException("Duplicate recipe " + finishedRecipe.func_200442_b());
            }
            try {
                JsonObject json = finishedRecipe.func_200441_a();
                this.injectConditions(finishedRecipe.func_200442_b(), json);
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)path.resolve("data/" + finishedRecipe.func_200442_b().func_110624_b() + "/recipes/" + finishedRecipe.func_200442_b().func_110623_a() + ".json"));
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save recipe {}", (Object)path, (Object)e);
            }
            JsonObject jsonObject = finishedRecipe.func_200440_c();
            if (jsonObject != null) {
                try {
                    this.injectConditions(finishedRecipe.func_200442_b(), jsonObject);
                    IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)jsonObject, (Path)path.resolve("data/" + finishedRecipe.func_200442_b().func_110624_b() + "/advancements/" + finishedRecipe.func_200443_d().func_110623_a() + ".json"));
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't save recipe advancement {}", (Object)path, (Object)e);
                }
            }
        });
    }

    protected abstract void buildRecipes(Consumer<IFinishedRecipe> var1);

    public static void netheriteSmithing(Consumer<IFinishedRecipe> finishedRecipeConsumer, Item ingredientItem, Item resultItem) {
        SmithingRecipeBuilder.func_240502_a_((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredientItem}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_234759_km_}), (Item)resultItem).func_240503_a_("has_netherite_ingot", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Items.field_234759_km_)).func_240504_a_(finishedRecipeConsumer, Registry.field_212630_s.func_177774_c((Object)resultItem.func_199767_j()).func_110623_a() + "_smithing");
    }

    public static void planksFromLog(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider planks, ITag<Item> log) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)planks, (int)4).func_203221_a(log).func_200490_a("planks").func_200483_a("has_log", (ICriterionInstance)PollinatedRecipeProvider.has(log)).func_200482_a(finishedRecipeConsumer);
    }

    public static void planksFromLogs(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider planks, ITag<Item> logs) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)planks, (int)4).func_203221_a(logs).func_200490_a("planks").func_200483_a("has_logs", (ICriterionInstance)PollinatedRecipeProvider.has(logs)).func_200482_a(finishedRecipeConsumer);
    }

    public static void woodFromLogs(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider wood, IItemProvider log) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wood, (int)3).func_200462_a(Character.valueOf('#'), log).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)PollinatedRecipeProvider.has(log)).func_200464_a(finishedRecipeConsumer);
    }

    public static void woodenBoat(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider boat, IItemProvider material) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)boat).func_200462_a(Character.valueOf('#'), material).func_200472_a("# #").func_200472_a("###").func_200473_b("boat").func_200465_a("in_water", (ICriterionInstance)PollinatedRecipeProvider.insideOf(Blocks.field_150355_j)).func_200464_a(finishedRecipeConsumer);
    }

    public static void woodenButton(Consumer<IFinishedRecipe> consumer, IItemProvider itemLike, IItemProvider itemLike2) {
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)itemLike).func_200487_b(itemLike2).func_200490_a("wooden_button").func_200483_a("has_planks", (ICriterionInstance)PollinatedRecipeProvider.has(itemLike2)).func_200482_a(consumer);
    }

    public static void woodenDoor(Consumer<IFinishedRecipe> consumer, IItemProvider itemLike, IItemProvider itemLike2) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)itemLike, (int)3).func_200462_a(Character.valueOf('#'), itemLike2).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200473_b("wooden_door").func_200465_a("has_planks", (ICriterionInstance)PollinatedRecipeProvider.has(itemLike2)).func_200464_a(consumer);
    }

    public static void woodenFence(Consumer<IFinishedRecipe> consumer, IItemProvider itemLike, IItemProvider itemLike2) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)itemLike, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), itemLike2).func_200472_a("W#W").func_200472_a("W#W").func_200473_b("wooden_fence").func_200465_a("has_planks", (ICriterionInstance)PollinatedRecipeProvider.has(itemLike2)).func_200464_a(consumer);
    }

    public static void woodenFenceGate(Consumer<IFinishedRecipe> consumer, IItemProvider itemLike, IItemProvider itemLike2) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)itemLike).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), itemLike2).func_200472_a("#W#").func_200472_a("#W#").func_200473_b("wooden_fence_gate").func_200465_a("has_planks", (ICriterionInstance)PollinatedRecipeProvider.has(itemLike2)).func_200464_a(consumer);
    }

    public static void woodenPressurePlate(Consumer<IFinishedRecipe> consumer, IItemProvider itemLike, IItemProvider itemLike2) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)itemLike).func_200462_a(Character.valueOf('#'), itemLike2).func_200472_a("##").func_200473_b("wooden_pressure_plate").func_200465_a("has_planks", (ICriterionInstance)PollinatedRecipeProvider.has(itemLike2)).func_200464_a(consumer);
    }

    public static void woodenSlab(Consumer<IFinishedRecipe> consumer, IItemProvider itemLike, IItemProvider itemLike2) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)itemLike, (int)6).func_200462_a(Character.valueOf('#'), itemLike2).func_200472_a("###").func_200473_b("wooden_slab").func_200465_a("has_planks", (ICriterionInstance)PollinatedRecipeProvider.has(itemLike2)).func_200464_a(consumer);
    }

    public static void woodenStairs(Consumer<IFinishedRecipe> consumer, IItemProvider itemLike, IItemProvider itemLike2) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)itemLike, (int)4).func_200462_a(Character.valueOf('#'), itemLike2).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200473_b("wooden_stairs").func_200465_a("has_planks", (ICriterionInstance)PollinatedRecipeProvider.has(itemLike2)).func_200464_a(consumer);
    }

    public static void woodenTrapdoor(Consumer<IFinishedRecipe> consumer, IItemProvider itemLike, IItemProvider itemLike2) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)itemLike, (int)2).func_200462_a(Character.valueOf('#'), itemLike2).func_200472_a("###").func_200472_a("###").func_200473_b("wooden_trapdoor").func_200465_a("has_planks", (ICriterionInstance)PollinatedRecipeProvider.has(itemLike2)).func_200464_a(consumer);
    }

    public static void woodenSign(Consumer<IFinishedRecipe> consumer, IItemProvider itemLike, IItemProvider itemLike2) {
        String string = Registry.field_212630_s.func_177774_c((Object)itemLike2.func_199767_j()).func_110623_a();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)itemLike, (int)3).func_200473_b("sign").func_200462_a(Character.valueOf('#'), itemLike2).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" X ").func_200465_a("has_" + string, (ICriterionInstance)PollinatedRecipeProvider.has(itemLike2)).func_200464_a(consumer);
    }

    public static void coloredWoolFromWhiteWoolAndDye(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider dyedWool, IItemProvider dye) {
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)dyedWool).func_200487_b(dye).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Blocks.field_196556_aL)).func_200482_a(finishedRecipeConsumer);
    }

    public static void carpetFromWool(Consumer<IFinishedRecipe> consumer, IItemProvider itemLike, IItemProvider itemLike2) {
        String string = Registry.field_212630_s.func_177774_c((Object)itemLike2.func_199767_j()).func_110623_a();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)itemLike, (int)3).func_200462_a(Character.valueOf('#'), itemLike2).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_" + string, (ICriterionInstance)PollinatedRecipeProvider.has(itemLike2)).func_200464_a(consumer);
    }

    public static void coloredCarpetFromWhiteCarpetAndDye(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider dyedCarpet, IItemProvider dye) {
        String string = Registry.field_212630_s.func_177774_c((Object)dyedCarpet.func_199767_j()).func_110623_a();
        String string2 = Registry.field_212630_s.func_177774_c((Object)dye.func_199767_j()).func_110623_a();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)dyedCarpet, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), dye).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Blocks.field_196724_fH)).func_200465_a("has_" + string2, (ICriterionInstance)PollinatedRecipeProvider.has(dye)).func_200466_a(finishedRecipeConsumer, string + "_from_white_carpet");
    }

    public static void bedFromPlanksAndWool(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider bed, IItemProvider wool) {
        String string = Registry.field_212630_s.func_177774_c((Object)wool.func_199767_j()).func_110623_a();
        ShapedRecipeBuilder.func_200470_a((IItemProvider)bed).func_200462_a(Character.valueOf('#'), wool).func_200469_a(Character.valueOf('X'), (ITag)ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_" + string, (ICriterionInstance)PollinatedRecipeProvider.has(wool)).func_200464_a(finishedRecipeConsumer);
    }

    public static void bedFromWhiteBedAndDye(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider dyedBed, IItemProvider dye) {
        String string = Registry.field_212630_s.func_177774_c((Object)dyedBed.func_199767_j()).func_110623_a();
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)dyedBed).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b(dye).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Items.field_196140_bu)).func_200484_a(finishedRecipeConsumer, string + "_from_white_bed");
    }

    public static void banner(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider banner, IItemProvider material) {
        String string = Registry.field_212630_s.func_177774_c((Object)material.func_199767_j()).func_110623_a();
        ShapedRecipeBuilder.func_200470_a((IItemProvider)banner).func_200462_a(Character.valueOf('#'), material).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_" + string, (ICriterionInstance)PollinatedRecipeProvider.has(material)).func_200464_a(finishedRecipeConsumer);
    }

    public static void stainedGlassFromGlassAndDye(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider stainedGlass, IItemProvider dye) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)stainedGlass, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), dye).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Blocks.field_150359_w)).func_200464_a(finishedRecipeConsumer);
    }

    public static void stainedGlassPaneFromStainedGlass(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider stainedGlassPane, IItemProvider stainedGlass) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)stainedGlassPane, (int)16).func_200462_a(Character.valueOf('#'), stainedGlass).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)PollinatedRecipeProvider.has(stainedGlass)).func_200464_a(finishedRecipeConsumer);
    }

    public static void stainedGlassPaneFromGlassPaneAndDye(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider stainedGlassPane, IItemProvider dye) {
        String string = Registry.field_212630_s.func_177774_c((Object)stainedGlassPane.func_199767_j()).func_110623_a();
        String string2 = Registry.field_212630_s.func_177774_c((Object)dye.func_199767_j()).func_110623_a();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)stainedGlassPane, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), dye).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Blocks.field_150410_aZ)).func_200465_a("has_" + string2, (ICriterionInstance)PollinatedRecipeProvider.has(dye)).func_200466_a(finishedRecipeConsumer, string + "_from_glass_pane");
    }

    public static void coloredTerracottaFromTerracottaAndDye(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider coloredTerracotta, IItemProvider dye) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)coloredTerracotta, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), dye).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Blocks.field_150405_ch)).func_200464_a(finishedRecipeConsumer);
    }

    public static void concretePowder(Consumer<IFinishedRecipe> finishedRecipeConsumer, IItemProvider dyedConcretePowder, IItemProvider dye) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)dyedConcretePowder, (int)8).func_200487_b(dye).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Blocks.field_150351_n)).func_200482_a(finishedRecipeConsumer);
    }

    public static void cookRecipes(Consumer<IFinishedRecipe> finishedRecipeConsumer, String cookingMethod, CookingRecipeSerializer<?> cookingSerializer, int cookingTime) {
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151082_bd}), (IItemProvider)Items.field_151083_be, (float)0.35f, (int)cookingTime, cookingSerializer).func_218628_a("has_beef", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Items.field_151082_bd)).func_218632_a(finishedRecipeConsumer, "cooked_beef_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151076_bf}), (IItemProvider)Items.field_151077_bg, (float)0.35f, (int)cookingTime, cookingSerializer).func_218628_a("has_chicken", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Items.field_151076_bf)).func_218632_a(finishedRecipeConsumer, "cooked_chicken_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW}), (IItemProvider)Items.field_196102_ba, (float)0.35f, (int)cookingTime, cookingSerializer).func_218628_a("has_cod", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Items.field_196086_aW)).func_218632_a(finishedRecipeConsumer, "cooked_cod_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_203214_jx}), (IItemProvider)Items.field_203180_bP, (float)0.1f, (int)cookingTime, cookingSerializer).func_218628_a("has_kelp", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Blocks.field_203214_jx)).func_218632_a(finishedRecipeConsumer, "dried_kelp_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196087_aX}), (IItemProvider)Items.field_196104_bb, (float)0.35f, (int)cookingTime, cookingSerializer).func_218628_a("has_salmon", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Items.field_196087_aX)).func_218632_a(finishedRecipeConsumer, "cooked_salmon_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179561_bm}), (IItemProvider)Items.field_179557_bn, (float)0.35f, (int)cookingTime, cookingSerializer).func_218628_a("has_mutton", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Items.field_179561_bm)).func_218632_a(finishedRecipeConsumer, "cooked_mutton_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151147_al}), (IItemProvider)Items.field_151157_am, (float)0.35f, (int)cookingTime, cookingSerializer).func_218628_a("has_porkchop", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Items.field_151147_al)).func_218632_a(finishedRecipeConsumer, "cooked_porkchop_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151174_bG}), (IItemProvider)Items.field_151168_bH, (float)0.35f, (int)cookingTime, cookingSerializer).func_218628_a("has_potato", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Items.field_151174_bG)).func_218632_a(finishedRecipeConsumer, "baked_potato_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179558_bo}), (IItemProvider)Items.field_179559_bp, (float)0.35f, (int)cookingTime, cookingSerializer).func_218628_a("has_rabbit", (ICriterionInstance)PollinatedRecipeProvider.has((IItemProvider)Items.field_179558_bo)).func_218632_a(finishedRecipeConsumer, "cooked_rabbit_from_" + cookingMethod);
    }

    public static EnterBlockTrigger.Instance insideOf(Block block) {
        return new EnterBlockTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, block, StatePropertiesPredicate.field_227178_a_);
    }

    public static InventoryChangeTrigger.Instance has(IItemProvider itemLike) {
        return PollinatedRecipeProvider.inventoryTrigger(ItemPredicate.Builder.func_200309_a().func_200308_a(itemLike).func_200310_b());
    }

    public static InventoryChangeTrigger.Instance has(ITag<Item> tag) {
        return PollinatedRecipeProvider.inventoryTrigger(ItemPredicate.Builder.func_200309_a().func_200307_a(tag).func_200310_b());
    }

    public static InventoryChangeTrigger.Instance inventoryTrigger(ItemPredicate ... predicate) {
        return new InventoryChangeTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, predicate);
    }

    public String func_200397_b() {
        return "Recipes";
    }
}

