/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.datagen.provider.SimpleConditionalDataProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PollinatedAdvancementProvider
extends SimpleConditionalDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public PollinatedAdvancementProvider(DataGenerator generator) {
        this.generator = generator;
    }

    protected abstract void registerAdvancements(Consumer<Advancement> var1);

    public void func_200398_a(DirectoryCache cache) {
        Path folder = this.generator.func_200391_b();
        HashSet set = new HashSet();
        Consumer<Advancement> registry = advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            Path path = PollinatedAdvancementProvider.createPath(folder, advancement);
            JsonObject json = advancement.func_192075_a().func_200273_b();
            this.injectConditions(advancement.func_192067_g(), json);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save advancement {}", (Object)path, (Object)e);
            }
        };
        this.registerAdvancements(registry);
    }

    private static Path createPath(Path path, Advancement advancement) {
        return path.resolve("data/" + advancement.func_192067_g().func_110624_b() + "/advancements/" + advancement.func_192067_g().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Advancements";
    }
}

