/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen;

import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.jetbrains.annotations.Nullable;

public class BrewingRecipeBuilder {
    private final Potion result;
    private Potion from;
    private Ingredient ingredient;
    private final Advancement.Builder advancement = Advancement.Builder.func_200278_a();
    private String group;

    public BrewingRecipeBuilder(Potion result) {
        this.result = result;
    }

    public static BrewingRecipeBuilder shaped(Potion result) {
        return new BrewingRecipeBuilder(result);
    }

    public BrewingRecipeBuilder requires(Potion from, Ingredient ingredient) {
        this.from = from;
        this.ingredient = ingredient;
        return this;
    }

    public BrewingRecipeBuilder unlockedBy(String string, ICriterionInstance arg) {
        this.advancement.func_200275_a(string, arg);
        return this;
    }

    public BrewingRecipeBuilder group(String string) {
        this.group = string;
        return this;
    }

    public void save(Consumer<IFinishedRecipe> consumer) {
        this.save(consumer, Registry.field_212621_j.func_177774_c((Object)this.result));
    }

    public void save(Consumer<IFinishedRecipe> consumer, String string) {
        ResourceLocation key = Registry.field_212621_j.func_177774_c((Object)this.result);
        if (new ResourceLocation(string).equals((Object)key)) {
            throw new IllegalStateException("Shaped Recipe " + string + " should remove its 'save' argument");
        }
        this.save(consumer, new ResourceLocation(string));
    }

    public void save(Consumer<IFinishedRecipe> consumer, ResourceLocation arg) {
        this.ensureValid(arg);
        this.advancement.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)arg)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)arg)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(new Result(arg, this.result, this.group == null ? "" : this.group, this.from, this.ingredient, this.advancement, new ResourceLocation(arg.func_110624_b(), "recipes/brewing/" + arg.func_110623_a())));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.from == null) {
            throw new IllegalStateException("No source potion is defined for brewing recipe " + id + "!");
        }
        if (this.ingredient == null || this.ingredient.func_203189_d()) {
            throw new IllegalStateException("No ingredient is defined for brewing recipe " + id + "!");
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Potion from;
        private final Ingredient ingredient;
        private final Potion result;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Potion result, String group, Potion from, Ingredient ingredient, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.result = result;
            this.group = group;
            this.from = from;
            this.ingredient = ingredient;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("from", Registry.field_212621_j.func_177774_c((Object)this.from).toString());
            json.add("ingredient", this.ingredient.func_200304_c());
            json.addProperty("result", Registry.field_212621_j.func_177774_c((Object)this.result).toString());
        }

        public IRecipeSerializer<?> func_218609_c() {
            return PollenRecipeTypes.BREWING.get();
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancement.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

