/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.crafting.grindstone;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import gg.moonflower.pollen.api.crafting.grindstone.PollenGrindstoneRecipe;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;

public class PollenShapelessGrindstoneRecipe
implements PollenGrindstoneRecipe {
    private final ResourceLocation id;
    private final String group;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final int experience;

    public PollenShapelessGrindstoneRecipe(ResourceLocation id, String group, ItemStack result, NonNullList<Ingredient> ingredients, int experience) {
        this.id = id;
        this.group = group;
        this.result = result;
        this.ingredients = NonNullList.func_191197_a((int)2, (Object)Ingredient.field_193370_a);
        for (int i = 0; i < Math.min(this.ingredients.size(), ingredients.size()); ++i) {
            this.ingredients.set(i, (Object)((Ingredient)ingredients.get(i)));
        }
        this.experience = experience;
    }

    public static NonNullList<Ingredient> itemsFromJson(JsonArray json) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (int i = 0; i < json.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.get(i));
            if (ingredient.func_203189_d()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    @ApiStatus.Internal
    public static PollenShapelessGrindstoneRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> ingredients = PollenShapelessGrindstoneRecipe.itemsFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for grindstone recipe");
        }
        if (ingredients.size() > 2) {
            throw new JsonParseException("Too many ingredients for grindstone recipe");
        }
        ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        int experience = JSONUtils.func_151208_a((JsonObject)json, (String)"experience", (int)0);
        return new PollenShapelessGrindstoneRecipe(recipeId, group, result, ingredients, experience);
    }

    @ApiStatus.Internal
    public static PollenShapelessGrindstoneRecipe fromNetwork(ResourceLocation id, PacketBuffer buf) {
        String group = buf.func_218666_n();
        ItemStack result = buf.func_150791_c();
        int experience = buf.func_150792_a();
        NonNullList ingredients = NonNullList.func_191197_a((int)buf.func_150792_a(), (Object)Ingredient.field_193370_a);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buf));
        }
        return new PollenShapelessGrindstoneRecipe(id, group, result, (NonNullList<Ingredient>)ingredients, experience);
    }

    @ApiStatus.Internal
    public static void toNetwork(PacketBuffer buf, PollenShapelessGrindstoneRecipe recipe) {
        buf.func_180714_a(recipe.group);
        buf.func_150788_a(recipe.result);
        buf.func_150787_b(recipe.experience);
        buf.func_150787_b(recipe.ingredients.size());
        for (Ingredient ingredient : recipe.ingredients) {
            ingredient.func_199564_a(buf);
        }
    }

    public boolean func_77569_a(IInventory container, World level) {
        RecipeItemHelper stackedContents = new RecipeItemHelper();
        int i = 0;
        for (int j = 0; j < 2; ++j) {
            ItemStack itemStack = container.func_70301_a(j);
            if (itemStack.func_190926_b()) continue;
            ++i;
            stackedContents.func_221264_a(itemStack, 1);
        }
        return i == this.ingredients.size() && stackedContents.func_194116_a((IRecipe)this, null);
    }

    public ItemStack func_77572_b(IInventory container) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int w, int h) {
        return w * h >= this.ingredients.size();
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return PollenRecipeTypes.GRINDSTONE.get();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    @Override
    public int getResultExperience() {
        return this.experience;
    }
}

