/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Stack;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.Validate;

public final class ScissorHelper {
    private static final Stack<Entry> stack = new Stack();
    public static int framebufferHeight = 0;
    public static double framebufferScale = 0.0;

    private ScissorHelper() {
    }

    private static void applyScissor() {
        if (!stack.isEmpty()) {
            Entry entry = stack.peek();
            MainWindow window = Minecraft.func_71410_x().func_228018_at_();
            double scale = framebufferScale == 0.0 ? window.func_198100_s() : framebufferScale;
            int frameHeight = framebufferHeight == 0 ? window.func_198091_l() : framebufferHeight;
            RenderSystem.enableScissor((int)((int)((double)entry.getX() * scale)), (int)((int)((double)frameHeight - (double)(entry.getY() + entry.getHeight()) * scale)), (int)MathHelper.func_76143_f((double)Math.max(0.0, (double)entry.getWidth() * scale)), (int)MathHelper.func_76143_f((double)Math.max(0.0, (double)entry.getHeight() * scale)));
        } else {
            RenderSystem.disableScissor();
        }
    }

    public static void push(float x, float y, float width, float height) {
        Validate.isTrue((width >= 0.0f ? 1 : 0) != 0, (String)"Scissor width cannot be negative", (Object[])new Object[0]);
        Validate.isTrue((height >= 0.0f ? 1 : 0) != 0, (String)"Scissor height cannot be negative", (Object[])new Object[0]);
        if (!stack.isEmpty()) {
            Entry parent = stack.peek();
            if (x + width > parent.getWidth()) {
                width = parent.getWidth() - x;
            }
            if (y + height > parent.getHeight()) {
                height = parent.getHeight() - y;
            }
            if (x < 0.0f) {
                width += x;
                x = 0.0f;
            }
            if (y < 0.0f) {
                height += y;
                y = 0.0f;
            }
            x += parent.getX();
            y += parent.getY();
        }
        stack.push(new Entry(x, y, width, height));
        ScissorHelper.applyScissor();
    }

    public static void pop() {
        if (!stack.isEmpty()) {
            stack.pop();
        }
        ScissorHelper.applyScissor();
    }

    public static void clear() {
        RenderSystem.disableScissor();
        stack.clear();
    }

    public static Entry getTop() {
        return stack.peek();
    }

    public static boolean isEmpty() {
        return stack.isEmpty();
    }

    public static class Entry {
        private final float x;
        private final float y;
        private final float width;
        private final float height;

        private Entry(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }
    }
}

