/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.block;

import com.google.common.base.Suppliers;
import gg.moonflower.pollen.api.fluid.PollinatedFluid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PollinatedLiquidBlock
extends Block
implements IBucketPickupHandler {
    public static final IntegerProperty LEVEL = BlockStateProperties.field_208132_ag;
    public static final VoxelShape STABLE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private final Supplier<FlowingFluid> fluid;
    private final Supplier<List<FluidState>> stateCache;

    public PollinatedLiquidBlock(Supplier<FlowingFluid> fluid, AbstractBlock.Properties properties) {
        super(properties);
        this.fluid = fluid;
        this.stateCache = Suppliers.memoize(() -> {
            FlowingFluid flowingFluid = (FlowingFluid)fluid.get();
            ArrayList<FluidState> list = new ArrayList<FluidState>();
            list.add(flowingFluid.func_207204_a(false));
            for (int i = 1; i < 8; ++i) {
                list.add(flowingFluid.func_207207_a(8 - i, false));
            }
            list.add(flowingFluid.func_207207_a(8, true));
            return list;
        });
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public PollinatedLiquidBlock(FlowingFluid fluid, AbstractBlock.Properties properties) {
        this(() -> fluid, properties);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        return context.func_216378_a(STABLE_SHAPE, pos, true) && (Integer)state.func_177229_b((Property)LEVEL) == 0 && context.func_230426_a_(level.func_204610_c(pos.func_177984_a()), this.getFluid()) ? STABLE_SHAPE : VoxelShapes.func_197880_a();
    }

    public boolean func_149653_t(BlockState state) {
        return state.func_204520_s().func_206890_h();
    }

    public void func_225542_b_(BlockState state, ServerWorld level, BlockPos pos, Random random) {
        state.func_204520_s().func_206891_b((World)level, pos, random);
    }

    public boolean func_200123_i(BlockState state, IBlockReader level, BlockPos pos) {
        return false;
    }

    public boolean func_196266_a(BlockState state, IBlockReader level, BlockPos pos, PathType type) {
        return !this.getFluid().func_207185_a((ITag)FluidTags.field_206960_b);
    }

    public FluidState func_204507_t(BlockState state) {
        return this.stateCache.get().get(Math.min((Integer)state.func_177229_b((Property)LEVEL), 8));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction direction) {
        return adjacentBlockState.func_204520_s().func_206886_c().func_207187_a((Fluid)this.getFluid());
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Collections.emptyList();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.shouldSpreadLiquid(level, pos)) {
            level.func_205219_F_().func_205360_a(pos, (Object)state.func_204520_s().func_206886_c(), this.getFluid().func_205569_a((IWorldReader)level));
        }
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld level, BlockPos currentPos, BlockPos neighborPos) {
        if (state.func_204520_s().func_206889_d() || neighborState.func_204520_s().func_206889_d()) {
            level.func_205219_F_().func_205360_a(currentPos, (Object)state.func_204520_s().func_206886_c(), this.getFluid().func_205569_a((IWorldReader)level));
        }
        return super.func_196271_a(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void func_220069_a(BlockState state, World level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.shouldSpreadLiquid(level, pos)) {
            level.func_205219_F_().func_205360_a(pos, (Object)state.func_204520_s().func_206886_c(), this.getFluid().func_205569_a((IWorldReader)level));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LEVEL});
    }

    public Fluid func_204508_a(IWorld levelAccessor, BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.func_177229_b((Property)LEVEL) == 0) {
            levelAccessor.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 11);
            return this.getFluid();
        }
        return Fluids.field_204541_a;
    }

    public FlowingFluid getFluid() {
        return this.fluid.get();
    }

    protected boolean shouldSpreadLiquid(World level, BlockPos pos) {
        Direction[] directions;
        if (!(this.fluid instanceof PollinatedFluid)) {
            return true;
        }
        PollinatedFluid behavior = (PollinatedFluid)((Object)this.fluid);
        FluidState fluidState = level.func_204610_c(pos);
        for (Direction direction : directions = behavior.getInteractionDirections()) {
            BlockPos blockPos = pos.func_177972_a(direction);
            BlockState interactionState = behavior.getInteractionState(level, fluidState, pos, blockPos);
            if (interactionState == null) continue;
            level.func_175656_a(pos, interactionState);
            behavior.playInteractionEffect(level, fluidState, pos);
            return false;
        }
        return true;
    }
}

