/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.datagen.recipe.Criteria;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class PneumaticCraftRecipeBuilder<T extends PneumaticCraftRecipeBuilder<T>> {
    protected final List<ICondition> conditions = new ArrayList<ICondition>();
    protected final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    protected final ResourceLocation serializerName;

    protected PneumaticCraftRecipeBuilder(ResourceLocation serializerName) {
        this.serializerName = serializerName;
    }

    public T addCriterion(Criteria.RecipeCriterion criterion) {
        return this.addCriterion(criterion.name, criterion.criterion);
    }

    public T addCriterion(String name, ICriterionInstance criterion) {
        this.advancementBuilder.func_200275_a(name, criterion);
        return (T)this;
    }

    public T addCondition(ICondition condition) {
        this.conditions.add(condition);
        return (T)this;
    }

    protected abstract RecipeResult getResult(ResourceLocation var1);

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(this.getResult(id));
    }

    protected abstract class RecipeResult
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final ResourceLocation advancementId;

        RecipeResult(ResourceLocation id) {
            this.id = id;
            this.advancementId = new ResourceLocation(id.func_110624_b(), "recipes/" + id.func_110623_a());
        }

        public JsonObject func_200441_a() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", PneumaticCraftRecipeBuilder.this.serializerName.toString());
            if (!PneumaticCraftRecipeBuilder.this.conditions.isEmpty()) {
                JsonArray conditionsArray = new JsonArray();
                for (ICondition condition : PneumaticCraftRecipeBuilder.this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                jsonObject.add("conditions", (JsonElement)conditionsArray);
            }
            this.func_218610_a(jsonObject);
            return jsonObject;
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(PneumaticCraftRecipeBuilder.this.serializerName);
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return PneumaticCraftRecipeBuilder.this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

