/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.datagen.recipe.PneumaticCraftRecipeBuilder;
import me.desht.pneumaticcraft.datagen.recipe.SerializerHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidMixerRecipeBuilder
extends PneumaticCraftRecipeBuilder<FluidMixerRecipeBuilder> {
    private final FluidIngredient input1;
    private final FluidIngredient input2;
    private final FluidStack outputFluid;
    private final ItemStack outputItem;
    private final float pressure;
    private final int processingTime;

    public FluidMixerRecipeBuilder(FluidIngredient input1, FluidIngredient input2, FluidStack outputFluid, ItemStack outputItem, float pressure, int processingTime) {
        super(PneumaticRegistry.RL("fluid_mixer"));
        this.input1 = input1;
        this.input2 = input2;
        this.outputFluid = outputFluid;
        this.outputItem = outputItem;
        this.pressure = pressure;
        this.processingTime = processingTime;
    }

    @Override
    protected PneumaticCraftRecipeBuilder.RecipeResult getResult(ResourceLocation id) {
        return new FluidMixerRecipeResult(id);
    }

    public class FluidMixerRecipeResult
    extends PneumaticCraftRecipeBuilder.RecipeResult {
        public FluidMixerRecipeResult(ResourceLocation id) {
            super(FluidMixerRecipeBuilder.this, id);
        }

        public void func_218610_a(JsonObject json) {
            json.add("input1", FluidMixerRecipeBuilder.this.input1.func_200304_c());
            json.add("input2", FluidMixerRecipeBuilder.this.input2.func_200304_c());
            if (!FluidMixerRecipeBuilder.this.outputFluid.isEmpty()) {
                json.add("fluid_output", (JsonElement)ModCraftingHelper.fluidStackToJson(FluidMixerRecipeBuilder.this.outputFluid));
            }
            if (!FluidMixerRecipeBuilder.this.outputItem.func_190926_b()) {
                json.add("item_output", SerializerHelper.serializeOneItemStack(FluidMixerRecipeBuilder.this.outputItem));
            }
            json.addProperty("pressure", (Number)Float.valueOf(FluidMixerRecipeBuilder.this.pressure));
            if (FluidMixerRecipeBuilder.this.processingTime != 200) {
                json.addProperty("time", (Number)FluidMixerRecipeBuilder.this.processingTime);
            }
        }
    }
}

