/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.datagen.loot.ModLootFunctions;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;

public class TileEntitySerializerFunction
extends LootFunction {
    private TileEntitySerializerFunction(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        return this.applyTEdata(stack, (TileEntity)context.func_216031_c(LootParameters.field_216288_h));
    }

    public static LootFunction.Builder<?> builder() {
        return TileEntitySerializerFunction.func_215860_a(TileEntitySerializerFunction::new);
    }

    private ItemStack applyTEdata(ItemStack teStack, TileEntity te) {
        CompoundNBT tag;
        CompoundNBT tankTag;
        CompoundNBT subTag;
        CompoundNBT nbt = teStack.func_179543_a("BlockEntityTag");
        CompoundNBT compoundNBT = subTag = nbt == null ? new CompoundNBT() : nbt;
        if (te instanceof ISerializableTanks && !(tankTag = ((ISerializableTanks)te).serializeTanks()).isEmpty()) {
            subTag.func_218657_a("SavedTanks", (INBT)tankTag);
        }
        if (te instanceof ISideConfigurable && !(tag = SideConfigurator.writeToNBT((ISideConfigurable)te)).isEmpty()) {
            subTag.func_218657_a("SideConfiguration", (INBT)tag);
        }
        if (te instanceof IRedstoneControl) {
            ((IRedstoneControl)te).getRedstoneController().serialize(subTag);
        }
        if (te instanceof TileEntityBase) {
            TileEntityBase teB = (TileEntityBase)te;
            if (teB.shouldPreserveStateOnBreak()) {
                TileEntityBase.UpgradeHandler upgradeHandler = teB.getUpgradeHandler();
                for (int i = 0; i < upgradeHandler.getSlots(); ++i) {
                    if (upgradeHandler.getStackInSlot(i).func_190926_b()) continue;
                    if (teB.getUpgrades(EnumUpgrade.CREATIVE) > 0) {
                        NBTUtils.setBoolean(teStack, "CreativeUpgrade", true);
                    } else {
                        NBTUtils.removeTag(teStack, "CreativeUpgrade");
                    }
                    subTag.func_218657_a("UpgradeInventory", (INBT)upgradeHandler.serializeNBT());
                    break;
                }
                te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(h -> {
                    if (h.getPressure() != 0.0f) {
                        subTag.func_74768_a("AirAmount", h.getAir());
                    }
                });
            }
            teB.serializeExtraItemData(subTag, teB.shouldPreserveStateOnBreak());
        }
        if (!subTag.isEmpty()) {
            tag = teStack.func_196082_o();
            tag.func_218657_a("BlockEntityTag", (INBT)subTag);
        } else if (teStack.func_77942_o() && teStack.func_77978_p().func_74764_b("BlockEntityTag")) {
            teStack.func_77978_p().func_82580_o("BlockEntityTag");
        }
        return teStack;
    }

    public LootFunctionType func_230425_b_() {
        return ModLootFunctions.TE_SERIALIZER;
    }

    public static class Serializer
    extends LootFunction.Serializer<TileEntitySerializerFunction> {
        public TileEntitySerializerFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            return new TileEntitySerializerFunction(conditionsIn);
        }
    }
}

