/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;

public class NBTUtils {
    public static void initNBTTagCompound(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new CompoundNBT());
        }
    }

    public static boolean hasTag(ItemStack itemStack, String tagName) {
        return itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b(tagName);
    }

    public static void removeTag(ItemStack itemStack, String tagName) {
        if (itemStack.func_77978_p() != null) {
            itemStack.func_77978_p().func_82580_o(tagName);
        }
    }

    public static String getString(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(tagName)) {
            NBTUtils.setString(itemStack, tagName, "");
        }
        return itemStack.func_77978_p().func_74779_i(tagName);
    }

    public static void setString(ItemStack itemStack, String tagName, String tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74778_a(tagName, tagValue);
    }

    public static boolean getBoolean(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(tagName)) {
            NBTUtils.setBoolean(itemStack, tagName, false);
        }
        return itemStack.func_77978_p().func_74767_n(tagName);
    }

    public static void setBoolean(ItemStack itemStack, String tagName, boolean tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74757_a(tagName, tagValue);
    }

    public static byte getByte(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(tagName)) {
            NBTUtils.setByte(itemStack, tagName, (byte)0);
        }
        return itemStack.func_77978_p().func_74771_c(tagName);
    }

    public static void setByte(ItemStack itemStack, String tagName, byte tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74774_a(tagName, tagValue);
    }

    public static short getShort(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(tagName)) {
            NBTUtils.setShort(itemStack, tagName, (short)0);
        }
        return itemStack.func_77978_p().func_74765_d(tagName);
    }

    public static void setShort(ItemStack itemStack, String tagName, short tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74777_a(tagName, tagValue);
    }

    public static int getInteger(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(tagName)) {
            NBTUtils.setInteger(itemStack, tagName, 0);
        }
        return itemStack.func_77978_p().func_74762_e(tagName);
    }

    public static void setInteger(ItemStack itemStack, String tagName, int tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74768_a(tagName, tagValue);
    }

    public static long getLong(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(tagName)) {
            NBTUtils.setLong(itemStack, tagName, 0L);
        }
        return itemStack.func_77978_p().func_74763_f(tagName);
    }

    public static void setLong(ItemStack itemStack, String tagName, long tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74772_a(tagName, tagValue);
    }

    public static float getFloat(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(tagName)) {
            NBTUtils.setFloat(itemStack, tagName, 0.0f);
        }
        return itemStack.func_77978_p().func_74760_g(tagName);
    }

    public static void setFloat(ItemStack itemStack, String tagName, float tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74776_a(tagName, tagValue);
    }

    public static double getDouble(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(tagName)) {
            NBTUtils.setDouble(itemStack, tagName, 0.0);
        }
        return itemStack.func_77978_p().func_74769_h(tagName);
    }

    public static void setDouble(ItemStack itemStack, String tagName, double tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74780_a(tagName, tagValue);
    }

    public static CompoundNBT getCompoundTag(ItemStack itemStack, String tagName) {
        NBTUtils.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(tagName)) {
            itemStack.func_77978_p().func_218657_a(tagName, (INBT)new CompoundNBT());
        }
        return itemStack.func_77978_p().func_74775_l(tagName);
    }

    public static void setCompoundTag(ItemStack itemStack, String tagName, INBT tagValue) {
        NBTUtils.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_218657_a(tagName, tagValue);
    }

    public static void setPos(ItemStack stack, Vector3i vec) {
        NBTUtils.initNBTTagCompound(stack);
        NBTUtils.setPos(stack.func_77978_p(), vec);
    }

    public static BlockPos getPos(ItemStack stack) {
        NBTUtils.initNBTTagCompound(stack);
        return NBTUtils.getPos(stack.func_77978_p());
    }

    public static void setPos(CompoundNBT tag, Vector3i vec) {
        tag.func_74768_a("x", vec.func_177958_n());
        tag.func_74768_a("y", vec.func_177956_o());
        tag.func_74768_a("z", vec.func_177952_p());
    }

    public static BlockPos getPos(CompoundNBT tag) {
        return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public static boolean fromTag(CompoundNBT tag, String name, boolean def) {
        return tag.func_74764_b(name) ? tag.func_74767_n(name) : def;
    }

    public static int fromTag(CompoundNBT tag, String name, int def) {
        return tag.func_74764_b(name) ? tag.func_74762_e(name) : def;
    }

    public static String fromTag(CompoundNBT tag, String name, String def) {
        return tag.func_74764_b(name) ? tag.func_74779_i(name) : def;
    }

    public static float fromTag(CompoundNBT tag, String name, float def) {
        return tag.func_74764_b(name) ? tag.func_74760_g(name) : def;
    }

    public static ListNBT serializeTextComponents(List<ITextComponent> textComponents) {
        ListNBT l = new ListNBT();
        textComponents.forEach(t -> l.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)t))));
        return l;
    }

    public static List<ITextComponent> deserializeTextComponents(ListNBT l) {
        return l.stream().filter(nbt -> nbt instanceof StringNBT).map(nbt -> ITextComponent.Serializer.func_240643_a_((String)nbt.func_150285_a_())).collect(Collectors.toList());
    }
}

