/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

public class JsonToNBTConverter {
    private final String jsonString;

    public JsonToNBTConverter(String jsonString) {
        this.jsonString = jsonString;
    }

    public CompoundNBT convert() {
        JsonParser parser = new JsonParser();
        JsonElement el = parser.parse(this.jsonString);
        return JsonToNBTConverter.getTag((JsonObject)el);
    }

    public static CompoundNBT getTag(JsonObject object) {
        CompoundNBT nbt = new CompoundNBT();
        block12: for (Map.Entry entry : object.entrySet()) {
            JsonObject keyObject = ((JsonElement)entry.getValue()).getAsJsonObject();
            int type = keyObject.get("type").getAsInt();
            JsonElement element = keyObject.get("value");
            switch (type) {
                case 1: {
                    nbt.func_74774_a((String)entry.getKey(), (byte)element.getAsDouble());
                    continue block12;
                }
                case 2: {
                    nbt.func_74777_a((String)entry.getKey(), (short)element.getAsDouble());
                    continue block12;
                }
                case 3: {
                    nbt.func_74768_a((String)entry.getKey(), (int)element.getAsDouble());
                    continue block12;
                }
                case 4: {
                    nbt.func_74772_a((String)entry.getKey(), (long)element.getAsDouble());
                    continue block12;
                }
                case 5: {
                    nbt.func_74776_a((String)entry.getKey(), (float)element.getAsDouble());
                    continue block12;
                }
                case 6: {
                    nbt.func_74780_a((String)entry.getKey(), element.getAsDouble());
                    continue block12;
                }
                case 8: {
                    nbt.func_74778_a((String)entry.getKey(), element.getAsString());
                    continue block12;
                }
                case 9: {
                    JsonArray array = element.getAsJsonArray();
                    ListNBT tagList = new ListNBT();
                    for (JsonElement e : array) {
                        if (e.isJsonObject()) {
                            tagList.add(tagList.size(), (INBT)JsonToNBTConverter.getTag(e.getAsJsonObject()));
                            continue;
                        }
                        tagList.add(tagList.size(), (INBT)StringNBT.func_229705_a_((String)e.getAsString()));
                    }
                    nbt.func_218657_a((String)entry.getKey(), (INBT)tagList);
                    continue block12;
                }
                case 10: {
                    nbt.func_218657_a((String)entry.getKey(), (INBT)JsonToNBTConverter.getTag(element.getAsJsonObject()));
                    continue block12;
                }
                case 11: {
                    JsonArray array = element.getAsJsonArray();
                    int[] intArray = new int[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        intArray[i] = array.get(i).getAsInt();
                    }
                    nbt.func_218657_a((String)entry.getKey(), (INBT)new IntArrayNBT(intArray));
                    continue block12;
                }
            }
            throw new IllegalArgumentException("NBT type no " + type + " is not supported by the Json to NBT converter!");
        }
        return nbt;
    }
}

