/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class GlobalPosHelper {
    public static CompoundNBT toNBT(GlobalPos globalPos) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)globalPos.func_218180_b()));
        tag.func_74778_a("dim", globalPos.func_239646_a_().func_240901_a_().toString());
        return tag;
    }

    public static GlobalPos fromNBT(CompoundNBT tag) {
        RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(tag.func_74779_i("dim")));
        return GlobalPos.func_239648_a_((RegistryKey)worldKey, (BlockPos)NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("pos")));
    }

    public static JsonElement toJson(GlobalPos pos) {
        JsonObject posObj = new JsonObject();
        posObj.addProperty("x", (Number)pos.func_218180_b().func_177958_n());
        posObj.addProperty("y", (Number)pos.func_218180_b().func_177956_o());
        posObj.addProperty("z", (Number)pos.func_218180_b().func_177952_p());
        JsonObject obj = new JsonObject();
        obj.addProperty("dimension", pos.func_239646_a_().func_240901_a_().toString());
        obj.add("pos", (JsonElement)posObj);
        return obj;
    }

    public static GlobalPos fromJson(JsonObject json) {
        RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"dimension")));
        JsonObject posObj = json.get("pos").getAsJsonObject();
        BlockPos pos = new BlockPos(JSONUtils.func_151203_m((JsonObject)posObj, (String)"x"), JSONUtils.func_151203_m((JsonObject)posObj, (String)"y"), JSONUtils.func_151203_m((JsonObject)posObj, (String)"z"));
        return GlobalPos.func_239648_a_((RegistryKey)worldKey, (BlockPos)pos);
    }

    public static ServerWorld getWorldForGlobalPos(GlobalPos pos) {
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(pos.func_239646_a_());
    }

    public static GlobalPos makeGlobalPos(World w, BlockPos pos) {
        return GlobalPos.func_239648_a_((RegistryKey)w.func_234923_W_(), (BlockPos)pos);
    }

    public static boolean isSameWorld(GlobalPos pos, World world) {
        return pos.func_239646_a_().compareTo(world.func_234923_W_()) == 0;
    }

    public static String prettyPrint(GlobalPos pos) {
        BlockPos p = pos.func_218180_b();
        String dim = pos.func_239646_a_().func_240901_a_().toString();
        return String.format("%s [%d,%d,%d]", dim, p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
    }

    public static TileEntity getTileEntity(GlobalPos globalPos) {
        ServerWorld world = GlobalPosHelper.getWorldForGlobalPos(globalPos);
        if (world != null && world.isAreaLoaded(globalPos.func_218180_b(), 1)) {
            return world.func_175625_s(globalPos.func_218180_b());
        }
        return null;
    }
}

