/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CountedItemStacks
extends Object2IntOpenCustomHashMap<ItemStack> {
    private final boolean canCoalesce;

    public CountedItemStacks() {
        super((Hash.Strategy)new ItemStackHashingStrategy());
        this.canCoalesce = false;
    }

    public CountedItemStacks(IItemHandler handler) {
        super(handler.getSlots(), (Hash.Strategy)new ItemStackHashingStrategy());
        boolean canCoalesce = false;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            int seenAlready = this.getInt(stack);
            if (seenAlready > 0 && seenAlready + stack.func_190916_E() <= stack.func_77976_d()) {
                canCoalesce = true;
            }
            this.put(stack, seenAlready + stack.func_190916_E());
        }
        this.canCoalesce = canCoalesce;
    }

    public boolean canCoalesce() {
        return this.canCoalesce;
    }

    public NonNullList<ItemStack> coalesce() {
        NonNullList coalesced = NonNullList.func_191196_a();
        this.forEach((stack, amount) -> {
            while (amount > 0) {
                int toTake = Math.min(amount, stack.func_77976_d());
                amount = amount - toTake;
                coalesced.add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)toTake));
            }
        });
        return coalesced;
    }

    private static class ItemStackHashingStrategy
    implements Hash.Strategy<ItemStack> {
        private ItemStackHashingStrategy() {
        }

        public int hashCode(ItemStack object) {
            return Objects.hash(object.func_77973_b(), object.func_77978_p());
        }

        public boolean equals(ItemStack o1, ItemStack o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.func_77973_b() == o2.func_77973_b() && ItemStack.func_77970_a((ItemStack)o1, (ItemStack)o2);
        }
    }
}

