/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerThermopneumaticProcessingPlant;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.tileentity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.AcceptabilityCache;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityThermopneumaticProcessingPlant
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControl<TileEntityThermopneumaticProcessingPlant>,
ISerializableTanks,
IAutoFluidEjecting,
INamedContainerProvider,
IComparatorSupport,
IHeatExchangingTE {
    private static final int INVENTORY_SIZE = 1;
    private static final int CRAFTING_TIME = 6000;
    private static final double MAX_SPEED_UP = 2.5;
    private static final AcceptabilityCache<Item> acceptedItemCache = new AcceptabilityCache();
    private static final AcceptabilityCache<Fluid> acceptedFluidCache = new AcceptabilityCache();
    @GuiSynced
    @DescSynced
    private final ThermopneumaticFluidTankInput inputTank = new ThermopneumaticFluidTankInput(16000);
    @GuiSynced
    @DescSynced
    private final SmartSyncTank outputTank = new SmartSyncTank(this, 16000);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    @GuiSynced
    public final RedstoneController<TileEntityThermopneumaticProcessingPlant> rsController = new RedstoneController<TileEntityThermopneumaticProcessingPlant>(this);
    @GuiSynced
    private int craftingProgress;
    @GuiSynced
    private float requiredPressure;
    @GuiSynced
    public int minTemperature;
    @GuiSynced
    public int maxTemperature;
    @GuiSynced
    public TPProblem problem = TPProblem.OK;
    @DescSynced
    private boolean didWork;
    @GuiSynced
    private String currentRecipeIdSynced = "";
    private ThermoPlantRecipe currentRecipe;
    private boolean searchForRecipe = true;
    private final ItemStackHandler inputItemHandler = new InputItemHandler(this);
    private final ItemStackHandler outputItemHandler = new BaseItemStackHandler(this, 1);
    private final ThermopneumaticInvWrapper invWrapper = new ThermopneumaticInvWrapper((IItemHandler)this.inputItemHandler, (IItemHandler)this.outputItemHandler);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.invWrapper);
    private final ThermopneumaticFluidHandler fluidHandler = new ThermopneumaticFluidHandler();
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.fluidHandler);
    private double airUsage;

    public TileEntityThermopneumaticProcessingPlant() {
        super((TileEntityType)ModTileEntities.THERMOPNEUMATIC_PROCESSING_PLANT.get(), 5.0f, 7.0f, 3000, 4);
        this.heatExchanger.setThermalResistance(10.0);
    }

    @Override
    public boolean canConnectPneumatic(Direction dir) {
        return this.getRotation().func_176734_d() != dir && dir != Direction.UP;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.inputTank.tick();
        this.outputTank.tick();
        if (!this.func_145831_w().field_72995_K) {
            this.problem = TPProblem.OK;
            ThermoPlantRecipe prevRecipe = this.currentRecipe;
            if (this.searchForRecipe) {
                this.currentRecipe = this.findApplicableRecipe();
                this.currentRecipeIdSynced = this.currentRecipe == null ? "" : this.currentRecipe.func_199560_c().toString();
                this.searchForRecipe = false;
            }
            if (prevRecipe != this.currentRecipe) {
                this.func_145831_w().func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
            }
            this.didWork = false;
            if (this.currentRecipe != null) {
                if (this.getInputTank().getFluidAmount() < this.currentRecipe.getInputFluid().getAmount()) {
                    this.problem = TPProblem.NOT_ENOUGH_FLUID;
                } else if (this.heatExchanger.getTemperature() > (double)this.currentRecipe.getOperatingTemperature().getMax()) {
                    this.problem = TPProblem.TOO_HOT;
                } else if (this.heatExchanger.getTemperature() < (double)this.currentRecipe.getOperatingTemperature().getMin()) {
                    this.problem = TPProblem.TOO_COLD;
                } else if (this.rsController.shouldRun() && this.hasEnoughPressure()) {
                    double speedBoost;
                    double d = speedBoost = this.minTemperature > 0 ? Math.min(2.5, this.heatExchanger.getTemperature() / (double)this.minTemperature) : 1.0;
                    if (this.craftingProgress < 6000) {
                        double progressInc = speedBoost * this.currentRecipe.getRecipeSpeed() * 100.0;
                        this.craftingProgress = (int)((double)this.craftingProgress + progressInc);
                        double progressDivider = progressInc / 6000.0;
                        this.airUsage += (double)this.currentRecipe.airUsed() * progressDivider * speedBoost;
                        if (this.airUsage > 1.0) {
                            int i = (int)this.airUsage;
                            this.addAir(-i);
                            this.airUsage -= (double)i;
                        }
                        this.heatExchanger.addHeat(-this.currentRecipe.heatUsed(this.heatExchanger.getAmbientTemperature()) * speedBoost * 0.75 * progressDivider);
                    }
                    if (this.craftingProgress >= 6000) {
                        int filled = this.outputTank.fill(this.currentRecipe.getOutputFluid().copy(), IFluidHandler.FluidAction.SIMULATE);
                        ItemStack excess = this.outputItemHandler.insertItem(0, this.currentRecipe.getOutputItem().func_77946_l(), true);
                        if (filled == this.currentRecipe.getOutputFluid().getAmount() && excess.func_190926_b()) {
                            this.outputTank.fill(this.currentRecipe.getOutputFluid().copy(), IFluidHandler.FluidAction.EXECUTE);
                            this.outputItemHandler.insertItem(0, this.currentRecipe.getOutputItem().func_77946_l(), false);
                            this.inputTank.drain(this.currentRecipe.getInputFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                            this.inputItemHandler.extractItem(0, 1, false);
                            this.craftingProgress -= 6000;
                        } else {
                            this.problem = TPProblem.OUTPUT_BLOCKED;
                        }
                    }
                    this.didWork = this.problem == TPProblem.OK;
                }
            } else {
                this.problem = TPProblem.NO_RECIPE;
                this.craftingProgress = 0;
                this.minTemperature = 0;
                this.maxTemperature = 0;
                this.requiredPressure = 0.0f;
            }
        } else if (this.didWork && this.func_145831_w().field_73012_v.nextBoolean()) {
            ClientUtils.emitParticles(this.func_145831_w(), this.func_174877_v(), (IParticleData)ParticleTypes.field_197601_L, 0.9);
        }
    }

    private boolean hasEnoughPressure() {
        if (this.getMinWorkingPressure() == 0.0f) {
            return true;
        }
        if (this.getMinWorkingPressure() > 0.0f) {
            return this.getPressure() >= this.getMinWorkingPressure();
        }
        return this.getPressure() <= this.getMinWorkingPressure();
    }

    private ThermoPlantRecipe findApplicableRecipe() {
        for (ThermoPlantRecipe recipe : PneumaticCraftRecipeType.THERMO_PLANT.getRecipes(this.field_145850_b).values()) {
            if (!recipe.matches(this.inputTank.getFluid(), this.inputItemHandler.getStackInSlot(0))) continue;
            this.requiredPressure = recipe.getRequiredPressure();
            this.minTemperature = recipe.getOperatingTemperature().getMin();
            this.maxTemperature = recipe.getOperatingTemperature().getMax();
            return recipe;
        }
        return null;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public IFluidTank getInputTank() {
        return this.inputTank;
    }

    public IFluidTank getOutputTank() {
        return this.outputTank;
    }

    public double getCraftingPercentage() {
        return (double)this.craftingProgress / 6000.0;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.inputItemHandler.serializeNBT());
        tag.func_218657_a("Output", (INBT)this.outputItemHandler.serializeNBT());
        tag.func_74768_a("craftingProgress", this.craftingProgress);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inputItemHandler.deserializeNBT(tag.func_74775_l("Items"));
        this.outputItemHandler.deserializeNBT(tag.func_74775_l("Output"));
        this.craftingProgress = tag.func_74762_e("craftingProgress");
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        FluidStack moved;
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.equals("dump") && !(moved = shiftHeld ? this.inputTank.drain(this.inputTank.getCapacity(), IFluidHandler.FluidAction.EXECUTE) : FluidUtil.tryFluidTransfer((IFluidHandler)this.outputTank, (IFluidHandler)this.inputTank, (int)this.inputTank.getFluidAmount(), (boolean)true)).isEmpty()) {
            NetworkHandler.sendToPlayer(new PacketPlaySound(SoundEvents.field_187630_M, SoundCategory.BLOCKS, this.field_174879_c, 1.0f, 1.0f, false), player);
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inputItemHandler;
    }

    @Override
    public RedstoneController<TileEntityThermopneumaticProcessingPlant> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return this.requiredPressure;
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"InputTank", (Object)this.inputTank, (Object)"OutputTank", (Object)this.outputTank);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerThermopneumaticProcessingPlant(i, playerInventory, this.func_174877_v());
    }

    public IItemHandler getOutputInventory() {
        return this.outputItemHandler;
    }

    @Override
    public int getComparatorValue() {
        return this.currentRecipe != null ? 15 : 0;
    }

    public static void clearCachedItemsAndFluids() {
        acceptedItemCache.clear();
        acceptedFluidCache.clear();
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }

    @Override
    public String getCurrentRecipeIdSynced() {
        return this.currentRecipeIdSynced;
    }

    public static enum TPProblem implements ITranslatableEnum
    {
        OK(""),
        NO_RECIPE("noRecipe"),
        NOT_ENOUGH_FLUID("notEnoughFluid"),
        TOO_HOT("tooMuchHeat"),
        TOO_COLD("notEnoughHeat"),
        OUTPUT_BLOCKED("outputBlocked");

        private final String key;

        private TPProblem(String key) {
            this.key = key;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.problems." + this.key;
        }
    }

    private class ThermopneumaticInvWrapper
    implements IItemHandler {
        private final IItemHandler input;
        private final IItemHandler output;

        ThermopneumaticInvWrapper(IItemHandler input, IItemHandler output) {
            this.input = input;
            this.output = output;
        }

        public int getSlots() {
            return 2;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? this.input.getStackInSlot(0) : this.output.getStackInSlot(0);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return slot == 0 ? TileEntityThermopneumaticProcessingPlant.this.inputItemHandler.insertItem(0, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot == 1 ? TileEntityThermopneumaticProcessingPlant.this.outputItemHandler.extractItem(0, amount, simulate) : ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? this.input.getSlotLimit(0) : this.output.getSlotLimit(0);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 ? this.input.isItemValid(0, stack) : this.output.isItemValid(0, stack);
        }
    }

    private class ThermopneumaticFluidHandler
    implements IFluidHandler {
        final IFluidTank[] tanks;

        ThermopneumaticFluidHandler() {
            this.tanks = new IFluidTank[]{TileEntityThermopneumaticProcessingPlant.this.inputTank, TileEntityThermopneumaticProcessingPlant.this.outputTank};
        }

        public int getTanks() {
            return this.tanks.length;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.tanks[tank].getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.tanks[tank].getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.tanks[tank].isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            return TileEntityThermopneumaticProcessingPlant.this.inputTank.fill(resource, doFill);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return TileEntityThermopneumaticProcessingPlant.this.outputTank.getFluid().isFluidEqual(resource) ? TileEntityThermopneumaticProcessingPlant.this.outputTank.drain(resource.getAmount(), doDrain) : FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return TileEntityThermopneumaticProcessingPlant.this.outputTank.drain(maxDrain, doDrain);
        }
    }

    private class InputItemHandler
    extends BaseItemStackHandler {
        private Item prev;

        public InputItemHandler(TileEntity te) {
            super(te, 1);
            this.prev = null;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_190926_b() || acceptedItemCache.isAcceptable(stack.func_77973_b(), () -> PneumaticCraftRecipeType.THERMO_PLANT.stream(TileEntityThermopneumaticProcessingPlant.this.field_145850_b).anyMatch(r -> r.getInputItem().test(stack)));
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (this.getStackInSlot(0).func_77973_b() != this.prev) {
                TileEntityThermopneumaticProcessingPlant.this.searchForRecipe = true;
            }
            this.prev = this.getStackInSlot(0).func_77973_b();
        }
    }

    private class ThermopneumaticFluidTankInput
    extends SmartSyncTank {
        ThermopneumaticFluidTankInput(int capacity) {
            super(TileEntityThermopneumaticProcessingPlant.this, capacity);
        }

        @Override
        public boolean isFluidValid(FluidStack fluid) {
            return fluid.isEmpty() || acceptedFluidCache.isAcceptable(fluid.getFluid(), () -> PneumaticCraftRecipeType.THERMO_PLANT.stream(TileEntityThermopneumaticProcessingPlant.this.field_145850_b).anyMatch(r -> r.getInputFluid().testFluid(fluid.getFluid())));
        }

        @Override
        protected void onContentsChanged(Fluid prevFluid, int prevAmount) {
            super.onContentsChanged(prevFluid, prevAmount);
            FluidStack newFluid = this.getFluid();
            if (prevFluid != newFluid.getFluid() || TileEntityThermopneumaticProcessingPlant.this.currentRecipe == null && this.getFluidAmount() > prevAmount || TileEntityThermopneumaticProcessingPlant.this.currentRecipe != null && this.getFluidAmount() < prevAmount) {
                TileEntityThermopneumaticProcessingPlant.this.searchForRecipe = true;
            }
        }
    }
}

