/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.BlockReinforcedChest;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerReinforcedChest;
import me.desht.pneumaticcraft.common.inventory.handler.ComparatorItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TileEntityReinforcedChest
extends TileEntityBase
implements INamedContainerProvider,
IComparatorSupport {
    public static final int CHEST_SIZE = 36;
    public static final String NBT_ITEMS = "Items";
    private static final String NBT_LOOT_TABLE = "LootTable";
    private static final String NBT_LOOT_TABLE_SEED = "LootTableSeed";
    private ResourceLocation lootTable;
    private long lootTableSeed;
    private final ComparatorItemStackHandler inventory = new ComparatorItemStackHandler(this, 36){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() != ((BlockReinforcedChest)ModBlocks.REINFORCED_CHEST.get()).func_199767_j() && super.isItemValid(slot, stack);
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileEntityReinforcedChest() {
        super((TileEntityType)ModTileEntities.REINFORCED_CHEST.get());
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.lootTable != null) {
            tag.func_74778_a(NBT_LOOT_TABLE, this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                tag.func_74772_a(NBT_LOOT_TABLE_SEED, this.lootTableSeed);
            }
        } else {
            tag.func_218657_a(NBT_ITEMS, (INBT)this.inventory.serializeNBT());
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_150297_b(NBT_LOOT_TABLE, 8)) {
            this.lootTable = new ResourceLocation(tag.func_74779_i(NBT_LOOT_TABLE));
            this.lootTableSeed = tag.func_74763_f(NBT_LOOT_TABLE_SEED);
        } else {
            this.inventory.deserializeNBT(tag.func_74775_l(NBT_ITEMS));
        }
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
    }

    @Override
    public void serializeExtraItemData(CompoundNBT blockEntityTag, boolean preserveState) {
        super.serializeExtraItemData(blockEntityTag, preserveState);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            blockEntityTag.func_218657_a(NBT_ITEMS, (INBT)this.inventory.serializeNBT());
            break;
        }
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        this.maybeFillWithLoot(player);
        return new ContainerReinforcedChest(windowId, inv, this.func_174877_v());
    }

    private void maybeFillWithLoot(PlayerEntity player) {
        if (this.lootTable != null && this.field_145850_b instanceof ServerWorld) {
            LootTable table = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(this.lootTable);
            this.lootTable = null;
            LootContext.Builder contextBuilder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216016_a(this.lootTableSeed);
            contextBuilder.func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)this.field_174879_c));
            if (player != null) {
                contextBuilder.func_186469_a(player.func_184817_da());
            }
            RecipeWrapper invWrapper = new RecipeWrapper((IItemHandlerModifiable)this.inventory);
            LootContext context = contextBuilder.func_216022_a(LootParameterSets.field_216261_b);
            table.func_216118_a((IInventory)invWrapper, context);
            this.func_70296_d();
        }
    }

    @Override
    public int getComparatorValue() {
        return this.inventory.getComparatorValue();
    }
}

