/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.BlockPneumaticDynamo;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.ContainerEnergy;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class TileEntityPneumaticDynamo
extends TileEntityPneumaticBase
implements IRedstoneControl<TileEntityPneumaticDynamo>,
IMinWorkingPressure,
INamedContainerProvider,
IHeatExchangingTE {
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    @GuiSynced
    private int rfPerTick;
    @GuiSynced
    private int airPerTick;
    private boolean isEnabled;
    @GuiSynced
    private final RedstoneController<TileEntityPneumaticDynamo> rsController = new RedstoneController<TileEntityPneumaticDynamo>(this);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);

    public TileEntityPneumaticDynamo() {
        super((TileEntityType)ModTileEntities.PNEUMATIC_DYNAMO.get(), 20.0f, 25.0f, 10000, 4);
    }

    public int getEfficiency() {
        return HeatUtil.getEfficiency(this.heatExchanger.getTemperatureAsInt());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            TileEntity receiver;
            boolean newEnabled;
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                int efficiency = Math.max(1, (Integer)ConfigHelper.common().machines.pneumaticDynamoEfficiency.get());
                this.airPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades() * 100.0f / (float)efficiency);
                this.rfPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades() * (float)this.getEfficiency() / 100.0f);
            }
            if (this.rsController.shouldRun() && this.getPressure() > this.getMinWorkingPressure() && this.energy.getMaxEnergyStored() - this.energy.getEnergyStored() >= this.rfPerTick) {
                this.addAir(-this.airPerTick);
                this.heatExchanger.addHeat((double)this.airPerTick / 100.0);
                this.energy.receiveEnergy(this.rfPerTick, false);
                newEnabled = true;
            } else {
                newEnabled = false;
            }
            if ((this.field_145850_b.func_82737_E() & 0xFL) == 0L && newEnabled != this.isEnabled) {
                this.isEnabled = newEnabled;
                BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockPneumaticDynamo.ACTIVE, (Comparable)Boolean.valueOf(this.isEnabled)));
            }
            if ((receiver = this.getCachedNeighbor(this.getRotation())) != null) {
                receiver.getCapability(CapabilityEnergy.ENERGY, this.getRotation().func_176734_d()).ifPresent(neighborStorage -> {
                    int extracted = this.energy.extractEnergy(this.rfPerTick * 2, true);
                    int energyPushed = neighborStorage.receiveEnergy(extracted, true);
                    if (energyPushed > 0) {
                        neighborStorage.receiveEnergy(this.energy.extractEnergy(energyPushed, false), false);
                    }
                });
            }
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public RedstoneController<TileEntityPneumaticDynamo> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == this.getRotation().func_176734_d();
    }

    @Override
    public float getMinWorkingPressure() {
        return 15.0f;
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    public int getRFRate() {
        return this.rfPerTick;
    }

    public int getAirRate() {
        return this.airPerTick;
    }

    public int getInfoEnergyStored() {
        return this.energy.getEnergyStored();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == CapabilityEnergy.ENERGY && (facing == this.getRotation() || facing == null) ? this.energyCap.cast() : super.getCapability(capability, facing);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.energy.writeToNBT(tag);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.energy.readFromNBT(tag);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerEnergy((ContainerType)ModContainers.PNEUMATIC_DYNAMO.get(), i, playerInventory, this.func_174877_v());
    }

    @Override
    @Nullable
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }
}

