/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticDoorBase;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticDoor;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.items.IItemHandler;

public class TileEntityPneumaticDoorBase
extends TileEntityPneumaticBase
implements IRedstoneControl<TileEntityPneumaticDoorBase>,
IMinWorkingPressure,
ICamouflageableTE,
INamedContainerProvider {
    private static final List<RedstoneController.RedstoneMode<TileEntityPneumaticDoorBase>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.ReceivingRedstoneMode<TileEntityPneumaticDoorBase>("pneumaticDoor.playerNearby", new ItemStack((IItemProvider)Items.field_221968_gp), te -> true), new RedstoneController.ReceivingRedstoneMode<TileEntityPneumaticDoorBase>("pneumaticDoor.playerNearbyAndLooking", new ItemStack((IItemProvider)Items.field_151061_bv), te -> true), new RedstoneController.ReceivingRedstoneMode<TileEntityPneumaticDoorBase>("pneumaticDoor.woodenDoor", new ItemStack((IItemProvider)Items.field_222015_iN), te -> true), new RedstoneController.ReceivingRedstoneMode<TileEntityPneumaticDoorBase>("pneumaticDoor.ironDoor", new ItemStack((IItemProvider)Items.field_222013_iM), te -> true));
    public static final int INVENTORY_SIZE = 1;
    private static final int RS_MODE_NEAR = 0;
    private static final int RS_MODE_NEAR_LOOKING = 1;
    public static final int RS_MODE_WOODEN_DOOR = 2;
    public static final int RS_MODE_IRON_DOOR = 3;
    private TileEntityPneumaticDoor door;
    private TileEntityPneumaticDoorBase doubleDoor;
    @DescSynced
    public boolean rightGoing;
    public float oldProgress;
    @DescSynced
    @LazySynced
    public float progress;
    @DescSynced
    private boolean opening;
    public boolean wasPowered;
    private BlockState camoState;
    @GuiSynced
    public final RedstoneController<TileEntityPneumaticDoorBase> rsController = new RedstoneController<TileEntityPneumaticDoorBase>(this, REDSTONE_MODES);
    @DescSynced
    private float speedMultiplier;
    @GuiSynced
    private boolean passSignal;
    private int rangeSq;

    public TileEntityPneumaticDoorBase() {
        super((TileEntityType)ModTileEntities.PNEUMATIC_DOOR_BASE.get(), 5.0f, 7.0f, 2000, 4);
    }

    @Override
    public void func_73660_a() {
        float targetProgress;
        super.func_73660_a();
        this.oldProgress = this.progress;
        if (!this.func_145831_w().field_72995_K) {
            if (this.getPressure() >= 2.0f) {
                if ((this.func_145831_w().func_82737_E() & 0x3FL) == 0L) {
                    TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177967_a(this.getRotation(), 3));
                    this.doubleDoor = te instanceof TileEntityPneumaticDoorBase ? (TileEntityPneumaticDoorBase)te : null;
                }
                this.setOpening(this.shouldOpen() || this.isNeighborOpening());
                this.setNeighborOpening(this.isOpening());
            } else {
                this.setOpening(true);
            }
            this.speedMultiplier = this.getSpeedMultiplierFromUpgrades();
        }
        float f = targetProgress = this.opening ? 1.0f : 0.0f;
        if (this.progress < targetProgress) {
            this.progress = (double)this.progress > 0.05 && this.progress < targetProgress - 0.15f ? (this.progress += 0.04f * this.speedMultiplier) : (float)((double)this.progress + Math.min(0.02, (double)(0.01f * this.speedMultiplier)));
            if (this.progress > targetProgress) {
                this.progress = targetProgress;
            }
        }
        if (this.progress > targetProgress) {
            this.progress = (double)this.progress < 0.95 && this.progress > targetProgress + 0.15f ? (this.progress -= 0.04f * this.speedMultiplier) : (float)((double)this.progress - Math.min(0.02, (double)(0.01f * this.speedMultiplier)));
            if (this.progress < targetProgress) {
                this.progress = targetProgress;
            }
        }
        if (!this.func_145831_w().field_72995_K && !PneumaticCraftUtils.epsilonEquals(this.oldProgress, this.progress)) {
            this.addAir((int)(-Math.abs(this.oldProgress - this.progress) * 300.0f * (this.getSpeedUsageMultiplierFromUpgrades() / this.speedMultiplier)));
        }
        this.door = this.getDoor();
        if (this.door != null) {
            this.door.setRotationAngle(this.progress * 90.0f);
            if (!this.func_145831_w().field_72995_K) {
                this.rightGoing = this.door.rightGoing;
            }
        }
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        this.rangeSq = IntMath.pow((int)(2 + this.getUpgrades(EnumUpgrade.RANGE)), (int)2);
    }

    private boolean shouldOpen() {
        if (this.door == null) {
            return false;
        }
        switch (this.rsController.getCurrentMode()) {
            case 0: {
                return this.hasAnyValidPlayer(player -> true);
            }
            case 1: {
                return this.hasAnyValidPlayer(this::isPlayerLookingAtDoor);
            }
            case 2: 
            case 3: {
                return this.rsController.getCurrentRedstonePower() > 0 || this.opening;
            }
        }
        return false;
    }

    private boolean hasAnyValidPlayer(Predicate<ServerPlayerEntity> pred) {
        if (this.field_145850_b != null && this.field_145850_b.func_73046_m() != null) {
            Vector3d vec = Vector3d.func_237489_a_((Vector3i)this.func_174877_v().func_177972_a(this.getRotation()));
            return this.field_145850_b.func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> player.func_195048_a(vec) <= (double)this.rangeSq).filter(player -> !TileEntitySecurityStation.isProtectedFromPlayer((PlayerEntity)player, this.func_174877_v(), false)).anyMatch(pred);
        }
        return false;
    }

    private boolean isPlayerLookingAtDoor(ServerPlayerEntity player) {
        Vector3d eyePos = player.func_174824_e(0.0f);
        Vector3d endPos = eyePos.func_178787_e(player.func_70040_Z().func_186678_a((double)this.rangeSq));
        return this.door.getRenderBoundingBox().func_216365_b(eyePos, endPos).isPresent();
    }

    public void setOpening(boolean opening) {
        boolean wasOpening = this.opening;
        this.opening = opening;
        if (this.opening != wasOpening) {
            NetworkHandler.sendToAllTracking((Object)new PacketPlaySound((SoundEvent)ModSounds.PNEUMATIC_DOOR.get(), SoundCategory.BLOCKS, this.func_174877_v(), 1.0f, 1.0f, false), this);
            this.sendDescriptionPacket();
        }
    }

    public boolean isOpening() {
        return this.opening;
    }

    private boolean isNeighborOpening() {
        return this.doubleDoor != null && this.doubleDoor.shouldOpen();
    }

    public void setNeighborOpening(boolean opening) {
        if (this.doubleDoor != null && this.doubleDoor.getPressure() >= 2.0f) {
            this.doubleDoor.setOpening(opening);
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP;
    }

    private TileEntityPneumaticDoor getDoor() {
        return PneumaticCraftUtils.getTileEntityAt((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(this.getRotation()).func_177977_b(), TileEntityPneumaticDoor.class).map(teDoor -> {
            if (this.getRotation().func_176746_e() == teDoor.getRotation() && !teDoor.rightGoing) {
                return teDoor;
            }
            if (this.getRotation().func_176735_f() == teDoor.getRotation() && teDoor.rightGoing) {
                return teDoor;
            }
            return null;
        }).orElse(null);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.progress = tag.func_74760_g("extension");
        this.opening = tag.func_74767_n("opening");
        this.rightGoing = tag.func_74767_n("rightGoing");
        this.passSignal = tag.func_74767_n("passSignal");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74776_a("extension", this.progress);
        tag.func_74757_a("opening", this.opening);
        tag.func_74757_a("rightGoing", this.rightGoing);
        tag.func_74757_a("passSignal", this.passSignal);
        return tag;
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        ICamouflageableTE.writeCamo(tag, this.camoState);
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.camoState = ICamouflageableTE.readCamo(tag);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.equals("pass_signal")) {
            this.passSignal = !this.passSignal;
            this.updateNeighbours();
            this.func_70296_d();
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public float getMinWorkingPressure() {
        return 2.0f;
    }

    @Override
    public RedstoneController<TileEntityPneumaticDoorBase> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        ICamouflageableTE.syncToClient(this);
    }

    @Override
    public IFormattableTextComponent getRedstoneTabTitle() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.redstoneBehaviour.pneumaticDoor.openWhen", new Object[0]);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerPneumaticDoorBase(i, playerInventory, this.func_174877_v());
    }

    public boolean shouldPassSignalToDoor() {
        return this.passSignal;
    }
}

