/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerAssemblyController;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IResettable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyDrill;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyIOUnit;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyLaser;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityAssemblyController
extends TileEntityPneumaticBase
implements IAssemblyMachine,
IMinWorkingPressure,
INamedContainerProvider {
    private static final int PROGRAM_SLOT = 0;
    private static final int INVENTORY_SIZE = 1;
    private final ItemStackHandler itemHandler = new BaseItemStackHandler(this, 1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() instanceof ItemAssemblyProgram;
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.itemHandler);
    public AssemblyProgram curProgram;
    @GuiSynced
    public boolean isMachineMissing;
    @GuiSynced
    public boolean isMachineDuplicate;
    @GuiSynced
    public AssemblyProgram.EnumMachine missingMachine;
    @GuiSynced
    public AssemblyProgram.EnumMachine duplicateMachine;
    private boolean goingToHomePosition;
    @DescSynced
    public String displayedText = "";
    @DescSynced
    public boolean hasProblem;
    private AssemblySystem assemblySystem = null;

    public TileEntityAssemblyController() {
        super((TileEntityType)ModTileEntities.ASSEMBLY_CONTROLLER.get(), 5.0f, 7.0f, 2000, 4);
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    public void func_73660_a() {
        ItemStack programStack = this.itemHandler.getStackInSlot(0);
        if (this.curProgram == null && !this.goingToHomePosition && programStack.func_77973_b() instanceof ItemAssemblyProgram) {
            this.curProgram = ItemAssemblyProgram.getProgram(programStack);
        } else if (this.curProgram != null && (programStack.func_190926_b() || this.curProgram.getType() != ItemAssemblyProgram.getProgram(programStack).getType())) {
            this.curProgram = null;
            if (!this.func_145831_w().field_72995_K) {
                this.goingToHomePosition = true;
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            this.setStatus("Standby");
            if (this.getPressure() >= 3.5f && (this.curProgram != null || this.goingToHomePosition)) {
                if (this.assemblySystem == null) {
                    this.assemblySystem = this.findAssemblySystem();
                }
                if (!(this.isMachineMissing && this.curProgram != null || this.isMachineDuplicate)) {
                    boolean useAir;
                    if (this.curProgram != null) {
                        useAir = this.curProgram.executeStep(this.assemblySystem);
                        if (useAir) {
                            this.setStatus("Running...");
                        }
                    } else {
                        useAir = true;
                        boolean resetDone = this.assemblySystem.reset();
                        this.goingToHomePosition = this.isMachineMissing || !resetDone;
                        this.setStatus("Resetting...");
                    }
                    if (useAir) {
                        this.addAir(-((int)(2.0f * this.getSpeedUsageMultiplierFromUpgrades())));
                    }
                    this.assemblySystem.setSpeed(this.getSpeedMultiplierFromUpgrades());
                }
            }
            this.hasProblem = this.isMachineMissing || this.isMachineDuplicate || this.getPressure() < 3.5f || this.curProgram == null || this.curProgram.curProblem != AssemblyProgram.EnumAssemblyProblem.NO_PROBLEM;
        }
        super.func_73660_a();
    }

    void invalidateAssemblySystem() {
        this.assemblySystem = null;
    }

    private AssemblySystem findAssemblySystem() {
        AssemblyProgram.EnumMachine[] requiredMachines = this.curProgram != null ? this.curProgram.getRequiredMachines() : AssemblyProgram.EnumMachine.values();
        this.duplicateMachine = null;
        AssemblySystem assemblySystem = new AssemblySystem(this.func_174877_v());
        for (IAssemblyMachine machine : this.findMachines(requiredMachines.length * 2)) {
            if (assemblySystem.addMachine(machine)) continue;
            this.duplicateMachine = machine.getAssemblyType();
        }
        this.missingMachine = assemblySystem.checkForMissingMachine(requiredMachines);
        this.isMachineDuplicate = this.duplicateMachine != null;
        this.isMachineMissing = this.missingMachine != null;
        return assemblySystem;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    private void setStatus(String text) {
        this.displayedText = text;
    }

    public List<IAssemblyMachine> findMachines(int max) {
        ArrayList<IAssemblyMachine> machineList = new ArrayList<IAssemblyMachine>();
        this.findMachines(machineList, this.func_174877_v(), max);
        return machineList;
    }

    private void findMachines(List<IAssemblyMachine> machineList, BlockPos pos, int max) {
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            TileEntity te = this.func_145831_w().func_175625_s(pos.func_177972_a(dir));
            if (!(te instanceof IAssemblyMachine) || machineList.contains(te) || machineList.size() >= max) continue;
            machineList.add((IAssemblyMachine)te);
            this.findMachines(machineList, te.func_174877_v(), max);
        }
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        this.invalidateAssemblySystem();
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.goingToHomePosition = tag.func_74767_n("goingToHomePosition");
        this.displayedText = tag.func_74779_i("displayedText");
        this.itemHandler.deserializeNBT(tag.func_74775_l("Items"));
        if (!this.itemHandler.getStackInSlot(0).func_190926_b()) {
            this.curProgram = ItemAssemblyProgram.getProgram(this.itemHandler.getStackInSlot(0));
            if (this.curProgram != null) {
                this.curProgram.readFromNBT(tag);
            }
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("goingToHomePosition", this.goingToHomePosition);
        tag.func_74778_a("displayedText", this.displayedText);
        if (this.curProgram != null) {
            this.curProgram.writeToNBT(tag);
        }
        tag.func_218657_a("Items", (INBT)this.itemHandler.serializeNBT());
        return tag;
    }

    @Override
    public boolean isIdle() {
        return true;
    }

    @Override
    public void setSpeed(float speed) {
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.5f;
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return AssemblyProgram.EnumMachine.CONTROLLER;
    }

    @Override
    public void setControllerPos(BlockPos controllerPos) {
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerAssemblyController(i, playerInventory, this.func_174877_v());
    }

    public static class AssemblySystem {
        private final EnumMap<AssemblyProgram.EnumMachine, IAssemblyMachine> machines = new EnumMap(AssemblyProgram.EnumMachine.class);
        private final BlockPos controllerPos;

        public AssemblySystem(BlockPos controllerPos) {
            this.controllerPos = controllerPos;
        }

        private IAssemblyMachine get(AssemblyProgram.EnumMachine machine) {
            return this.machines.get(machine);
        }

        boolean addMachine(IAssemblyMachine machine) {
            if (this.machines.containsKey(machine.getAssemblyType())) {
                return false;
            }
            this.machines.put(machine.getAssemblyType(), machine);
            machine.setControllerPos(this.controllerPos);
            return true;
        }

        boolean reset() {
            boolean resetDone = true;
            for (IAssemblyMachine machine : this.machines.values()) {
                if (!(machine instanceof IResettable) || ((IResettable)((Object)machine)).reset()) continue;
                resetDone = false;
                if (!(machine instanceof TileEntityAssemblyPlatform)) break;
                this.getExportUnit().pickupItem(null);
                break;
            }
            return resetDone;
        }

        void setSpeed(float speedMult) {
            this.machines.values().stream().filter(Objects::nonNull).forEach(te -> te.setSpeed(speedMult));
        }

        public TileEntityAssemblyIOUnit getImportUnit() {
            return (TileEntityAssemblyIOUnit)this.get(AssemblyProgram.EnumMachine.IO_UNIT_IMPORT);
        }

        public TileEntityAssemblyIOUnit getExportUnit() {
            return (TileEntityAssemblyIOUnit)this.get(AssemblyProgram.EnumMachine.IO_UNIT_EXPORT);
        }

        public TileEntityAssemblyPlatform getPlatform() {
            return (TileEntityAssemblyPlatform)this.get(AssemblyProgram.EnumMachine.PLATFORM);
        }

        public TileEntityAssemblyLaser getLaser() {
            return (TileEntityAssemblyLaser)this.get(AssemblyProgram.EnumMachine.LASER);
        }

        public TileEntityAssemblyDrill getDrill() {
            return (TileEntityAssemblyDrill)this.get(AssemblyProgram.EnumMachine.DRILL);
        }

        AssemblyProgram.EnumMachine checkForMissingMachine(AssemblyProgram.EnumMachine[] requiredMachines) {
            return Arrays.stream(requiredMachines).filter(e -> !this.machines.containsKey(e)).findFirst().orElse(null);
        }
    }
}

