/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei.ghost;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.semiblock.GuiLogisticsBase;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.inventory.ContainerLogistics;
import me.desht.pneumaticcraft.common.inventory.SlotPhantom;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class LogisticsFilterGhost<T extends EntityLogisticsFrame>
implements IGhostIngredientHandler<GuiLogisticsBase<T>> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(GuiLogisticsBase<T> gui, I ingredient, boolean doStart) {
        if (ingredient instanceof ItemStack) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Slot slot : ((ContainerLogistics)gui.func_212873_a_()).field_75151_b) {
                if (!(slot instanceof SlotPhantom)) continue;
                builder.add((Object)new ItemStackTarget((SlotPhantom)slot, gui));
            }
            return builder.build();
        }
        if (ingredient instanceof FluidStack) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < 9; ++i) {
                builder.add((Object)new FluidStackTarget(i, gui));
            }
            return builder.build();
        }
        return Collections.emptyList();
    }

    public void onComplete() {
    }

    private static class FluidStackTarget
    implements IGhostIngredientHandler.Target<FluidStack> {
        final int slotNumber;
        final GuiLogisticsBase<?> gui;

        FluidStackTarget(int slotNumber, GuiLogisticsBase<?> gui) {
            this.slotNumber = slotNumber;
            this.gui = gui;
        }

        public Rectangle2d getArea() {
            PointXY p = this.gui.getFluidSlotPos(this.slotNumber);
            return new Rectangle2d(p.x, p.y, 16, 16);
        }

        public void accept(FluidStack ingredient) {
            this.gui.updateFluidFilter(this.slotNumber, ingredient.copy());
        }
    }

    private static class ItemStackTarget
    implements IGhostIngredientHandler.Target<ItemStack> {
        final SlotPhantom slot;
        final GuiLogisticsBase<?> gui;

        ItemStackTarget(SlotPhantom slot, GuiLogisticsBase<?> gui) {
            this.slot = slot;
            this.gui = gui;
        }

        public Rectangle2d getArea() {
            return new Rectangle2d(this.gui.getGuiLeft() + this.slot.field_75223_e, this.gui.getGuiTop() + this.slot.field_75221_f, 16, 16);
        }

        public void accept(ItemStack ingredient) {
            this.gui.updateItemFilter(this.slot.getSlotIndex(), ingredient.func_77946_l());
        }
    }
}

