/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.common.block.BlockThermopneumaticProcessingPlant;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.Helpers;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class JEIThermopneumaticProcessingPlantCategory
extends AbstractPNCCategory<ThermoPlantRecipe> {
    private final ITickTimer tickTimer;
    private final Map<ResourceLocation, WidgetTemperature> tempWidgets = new HashMap<ResourceLocation, WidgetTemperature>();
    private final IDrawableAnimated progressBar;

    JEIThermopneumaticProcessingPlantCategory() {
        super(ModCategoryUid.THERMO_PLANT, ThermoPlantRecipe.class, (ITextComponent)PneumaticCraftUtils.xlate(((BlockThermopneumaticProcessingPlant)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get()).func_149739_a(), new Object[0]), (IDrawable)JEIThermopneumaticProcessingPlantCategory.guiHelper().createDrawable(Textures.GUI_JEI_THERMOPNEUMATIC_PROCESSING_PLANT, 0, 0, 166, 70), JEIThermopneumaticProcessingPlantCategory.guiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get())));
        this.tickTimer = JEIThermopneumaticProcessingPlantCategory.guiHelper().createTickTimer(60, 60, false);
        IDrawableStatic d = JEIThermopneumaticProcessingPlantCategory.guiHelper().createDrawable(Textures.GUI_THERMOPNEUMATIC_PROCESSING_PLANT, 176, 0, 48, 30);
        this.progressBar = JEIThermopneumaticProcessingPlantCategory.guiHelper().createAnimatedDrawable(d, 60, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setIngredients(ThermoPlantRecipe recipe, IIngredients ingredients) {
        if (!recipe.getInputFluid().func_203189_d()) {
            ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getInputFluid().getFluidStacks()));
        }
        if (!recipe.getInputItem().func_203189_d()) {
            ingredients.setInputIngredients(Collections.singletonList(recipe.getInputItem()));
        }
        if (!recipe.getOutputFluid().isEmpty()) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutputFluid());
        }
        if (!recipe.getOutputItem().func_190926_b()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutputItem());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, ThermoPlantRecipe recipe, IIngredients ingredients) {
        FluidStack in = ingredients.getInputs(VanillaTypes.FLUID).isEmpty() ? FluidStack.EMPTY : (FluidStack)((List)ingredients.getInputs(VanillaTypes.FLUID).get(0)).get(0);
        int inH = 64;
        int outH = 64;
        FluidStack out = FluidStack.EMPTY;
        if (!recipe.getOutputFluid().isEmpty()) {
            out = (FluidStack)((List)ingredients.getOutputs(VanillaTypes.FLUID).get(0)).get(0);
            if (in.getAmount() > out.getAmount()) {
                outH = Math.min(64, out.getAmount() * 64 / in.getAmount());
            } else {
                inH = Math.min(64, in.getAmount() * 64 / out.getAmount());
            }
        }
        if (!recipe.getInputFluid().func_203189_d()) {
            recipeLayout.getFluidStacks().init(0, true, 8, 3 + (64 - inH), 16, inH, in.getAmount(), false, Helpers.makeTankOverlay(inH));
            recipeLayout.getFluidStacks().set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        }
        if (!recipe.getInputItem().func_203189_d()) {
            recipeLayout.getItemStacks().init(0, true, 32, 2);
            recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        }
        if (!recipe.getOutputFluid().isEmpty()) {
            recipeLayout.getFluidStacks().init(1, false, 74, 3 + (64 - outH), 16, outH, out.getAmount(), false, Helpers.makeTankOverlay(outH));
            recipeLayout.getFluidStacks().set(1, recipe.getOutputFluid());
        }
        if (!recipe.getOutputItem().func_190926_b()) {
            recipeLayout.getItemStacks().init(1, false, 47, 50);
            recipeLayout.getItemStacks().set(1, recipe.getOutputItem());
        }
    }

    public void draw(ThermoPlantRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        if (recipe.getRequiredPressure() != 0.0f) {
            float pressure = recipe.getRequiredPressure() * ((float)this.tickTimer.getValue() / (float)this.tickTimer.getMaxValue());
            PressureGaugeRenderer2D.drawPressureGauge(matrixStack, Minecraft.func_71410_x().field_71466_p, -1.0f, 7.0f, 5.0f, recipe.getRequiredPressure(), pressure, 141, 42);
        }
        if (!recipe.getOperatingTemperature().isAny()) {
            WidgetTemperature w = this.tempWidgets.computeIfAbsent(recipe.func_199560_c(), id -> WidgetTemperature.fromOperatingRange(100, 12, recipe.getOperatingTemperature()));
            w.setTemperature(w.getTotalRange().getMin() + (w.getTotalRange().getMax() - w.getTotalRange().getMin()) * this.tickTimer.getValue() / this.tickTimer.getMaxValue());
            w.func_230430_a_(matrixStack, (int)mouseX, (int)mouseY, 0.0f);
        }
        this.progressBar.draw(matrixStack, 25, 20);
    }

    public List<ITextComponent> getTooltipStrings(ThermoPlantRecipe recipe, double mouseX, double mouseY) {
        ArrayList<ITextComponent> res = new ArrayList<ITextComponent>();
        WidgetTemperature w = this.tempWidgets.get(recipe.func_199560_c());
        if (w != null && w.func_231047_b_(mouseX, mouseY)) {
            res.add(HeatUtil.formatHeatString(recipe.getOperatingTemperature().asString(TemperatureRange.TemperatureScale.CELSIUS)));
        }
        if (recipe.getRequiredPressure() > 0.0f && mouseX >= 116.0 && mouseY >= 22.0 && mouseX <= 156.0 && mouseY <= 62.0) {
            res.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", Float.valueOf(recipe.getRequiredPressure())));
        }
        return res;
    }
}

