/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.crafttweaker.handlers;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.thirdparty.crafttweaker.CTUtils;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.pneumaticcraft.XPFluid")
@ZenRegister
public class XPFluid {
    @ZenCodeType.Method
    public void registerXPFluid(CTFluidIngredient fluid, int ratio) {
        CraftTweakerAPI.apply((IAction)new XPFluidActionAdd(fluid, ratio));
    }

    @ZenCodeType.Method
    public void unregisterXPFluid(CTFluidIngredient fluid) {
        CraftTweakerAPI.apply((IAction)new XPFluidActionAdd(fluid, 0));
    }

    public static class XPFluidActionAdd
    implements IRuntimeAction {
        private final CTFluidIngredient fluidIngredient;
        private final int ratio;

        public XPFluidActionAdd(CTFluidIngredient fluidIngredient, int ratio) {
            this.fluidIngredient = fluidIngredient;
            this.ratio = ratio;
        }

        public void apply() {
            XPFluidManager.getInstance().registerXPFluid(CTUtils.toFluidIngredient(this.fluidIngredient), this.ratio);
        }

        public String describe() {
            if (this.ratio <= 0) {
                return "Unregistering XP fluid " + this.fluidIngredient.getCommandString();
            }
            return "Registering XP fluid " + this.fluidIngredient.getCommandString() + " with mB->XP ratio: " + this.ratio;
        }
    }
}

