/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.common.block.BlockRefineryController;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public class RefineryRecipeImpl
extends RefineryRecipe {
    public final FluidIngredient input;
    public final List<FluidStack> outputs;
    private final TemperatureRange operatingTemp;

    public RefineryRecipeImpl(ResourceLocation id, FluidIngredient input, TemperatureRange operatingTemp, FluidStack ... outputs) {
        super(id);
        this.operatingTemp = operatingTemp;
        Validate.isTrue((outputs.length >= 2 && outputs.length <= 4 ? 1 : 0) != 0, (String)"Recipe must have between 2 and 4 (inclusive) outputs", (Object[])new Object[0]);
        this.input = input;
        this.outputs = ImmutableList.copyOf((Object[])outputs);
    }

    @Override
    public FluidIngredient getInput() {
        return this.input;
    }

    @Override
    public List<FluidStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public TemperatureRange getOperatingTemp() {
        return this.operatingTemp;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.func_199564_a(buffer);
        this.operatingTemp.write(buffer);
        buffer.func_150787_b(this.outputs.size());
        this.outputs.forEach(fluidStack -> fluidStack.writeToPacket(buffer));
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.REFINERY.get();
    }

    public IRecipeType<?> func_222127_g() {
        return PneumaticCraftRecipeType.REFINERY;
    }

    public String func_193358_e() {
        return ((BlockRefineryController)ModBlocks.REFINERY.get()).getRegistryName().func_110623_a();
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModBlocks.REFINERY.get());
    }

    public static class Serializer<T extends RefineryRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = FluidIngredient.func_199802_a((JsonElement)json.get("input"));
            TemperatureRange tempRange = json.has("temperature") ? TemperatureRange.fromJson(json.getAsJsonObject("temperature")) : TemperatureRange.min(373);
            JsonArray outputs = json.get("results").getAsJsonArray();
            if (outputs.size() < 2 || outputs.size() > 4) {
                throw new JsonSyntaxException("must be between 2 and 4 (inclusive) output fluids!");
            }
            ArrayList<FluidStack> results = new ArrayList<FluidStack>();
            for (JsonElement element : outputs) {
                results.add(ModCraftingHelper.fluidStackFromJson(element.getAsJsonObject()));
            }
            return this.factory.create(recipeId, (FluidIngredient)input, tempRange, results.toArray(new FluidStack[0]));
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            FluidIngredient input = (FluidIngredient)Ingredient.func_199566_b((PacketBuffer)buffer);
            TemperatureRange range = TemperatureRange.read(buffer);
            int nOutputs = buffer.func_150792_a();
            FluidStack[] outputs = new FluidStack[nOutputs];
            for (int i = 0; i < nOutputs; ++i) {
                outputs[i] = FluidStack.readFromPacket((PacketBuffer)buffer);
            }
            return this.factory.create(recipeId, input, range, outputs);
        }

        public void toNetwork(PacketBuffer buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends RefineryRecipe> {
            public T create(ResourceLocation var1, FluidIngredient var2, TemperatureRange var3, FluidStack ... var4);
        }
    }
}

