/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.ai.DroneAICrafting;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.ICraftingWidget;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.recipes.CraftingRecipeCache;
import me.desht.pneumaticcraft.common.util.DummyContainer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ProgWidgetCrafting
extends ProgWidget
implements ICraftingWidget,
ICountWidget,
ISidedWidget {
    private static final boolean[] NO_SIDES = new boolean[6];
    private boolean useCount;
    private int count;
    private boolean usingVariables;

    public ProgWidgetCrafting() {
        super((ProgWidgetType)ModProgWidgets.CRAFTING.get());
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        this.getCraftingGrid();
        if (!this.usingVariables && this.getRecipeResult(ClientUtils.getClientWorld()).func_190926_b()) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.crafting.error.noCraftingRecipe", new Object[0]));
        }
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        ItemStack stack = this.getRecipeResult(ClientUtils.getClientWorld());
        if (!stack.func_190926_b()) {
            curTooltip.add((ITextComponent)stack.func_200301_q().func_230532_e_().func_240699_a_(TextFormatting.YELLOW));
        }
        if (this.useCount()) {
            curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.inventory.usingCount", this.getCount()));
        }
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)ModProgWidgets.ITEM_FILTER.get(), (Object)ModProgWidgets.ITEM_FILTER.get(), (Object)ModProgWidgets.ITEM_FILTER.get());
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.PURPLE;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CRAFTING;
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public CraftingInventory getCraftingGrid() {
        this.usingVariables = false;
        CraftingInventory invCrafting = new CraftingInventory((Container)new DummyContainer(), 3, 3);
        for (int y = 0; y < 3; ++y) {
            ProgWidgetItemFilter itemFilter = (ProgWidgetItemFilter)this.getConnectedParameters()[y];
            for (int x = 0; x < 3 && itemFilter != null; ++x) {
                if (!itemFilter.getVariable().isEmpty()) {
                    this.usingVariables = true;
                }
                invCrafting.func_70299_a(y * 3 + x, itemFilter.getFilter());
                itemFilter = (ProgWidgetItemFilter)itemFilter.getConnectedParameters()[0];
            }
        }
        return invCrafting;
    }

    public ItemStack getRecipeResult(World world) {
        CraftingInventory grid = this.getCraftingGrid();
        return this.getRecipe(world, grid).map(r -> r.func_77572_b((IInventory)grid)).orElse(ItemStack.field_190927_a);
    }

    @Override
    public Optional<ICraftingRecipe> getRecipe(World world, CraftingInventory grid) {
        return this.usingVariables ? world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)grid, world) : CraftingRecipeCache.INSTANCE.getCachedRecipe(world, grid);
    }

    public static IRecipe<CraftingInventory> getRecipe(World world, ICraftingWidget widget) {
        return widget.getRecipe(world, widget.getCraftingGrid()).orElse(null);
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAICrafting(drone, (ICraftingWidget)((Object)widget));
    }

    @Override
    public void setSides(boolean[] sides) {
    }

    @Override
    public boolean[] getSides() {
        return NO_SIDES;
    }

    @Override
    public boolean useCount() {
        return this.useCount;
    }

    @Override
    public void setUseCount(boolean useCount) {
        this.useCount = useCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        if (this.useCount) {
            tag.func_74757_a("useCount", true);
        }
        tag.func_74768_a("count", this.count);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.useCount = tag.func_74767_n("useCount");
        this.count = tag.func_74762_e("count");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.useCount);
        buf.func_150787_b(this.count);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.useCount = buf.readBoolean();
        this.count = buf.func_150792_a();
    }
}

