/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.AxisOptions;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetConditionBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinateOperator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ProgWidgetCoordinateCondition
extends ProgWidgetConditionBase {
    private final AxisOptions axisOptions = new AxisOptions(false, false, false);
    private ICondition.Operator operator = ICondition.Operator.GE;

    public ProgWidgetCoordinateCondition() {
        super((ProgWidgetType)ModProgWidgets.CONDITION_COORDINATE.get());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)ModProgWidgets.COORDINATE.get(), (Object)ModProgWidgets.COORDINATE.get(), (Object)ModProgWidgets.TEXT.get());
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (!(this.axisOptions.shouldCheck(Direction.Axis.X) || this.axisOptions.shouldCheck(Direction.Axis.Y) || this.axisOptions.shouldCheck(Direction.Axis.Z))) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.conditionCoordinate.error.noAxisSelected", new Object[0]));
        }
    }

    @Override
    public boolean evaluate(IDroneBase drone, IProgWidget widget) {
        BlockPos pos1 = ProgWidgetCoordinateOperator.calculateCoordinate(widget, 0, ProgWidgetCoordinateOperator.EnumOperator.PLUS_MINUS);
        BlockPos pos2 = ProgWidgetCoordinateOperator.calculateCoordinate(widget, 1, ProgWidgetCoordinateOperator.EnumOperator.PLUS_MINUS);
        return !(this.axisOptions.shouldCheck(Direction.Axis.X) && !this.evaluate(pos1.func_177958_n(), pos2.func_177958_n()) || this.axisOptions.shouldCheck(Direction.Axis.Y) && !this.evaluate(pos1.func_177956_o(), pos2.func_177956_o()) || this.axisOptions.shouldCheck(Direction.Axis.Z) && !this.evaluate(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public AxisOptions getAxisOptions() {
        return this.axisOptions;
    }

    private boolean evaluate(int arg1, int arg2) {
        return this.operator.evaluate(arg1, arg2);
    }

    public ICondition.Operator getOperator() {
        return this.operator;
    }

    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        this.axisOptions.writeToNBT(tag);
        tag.func_74774_a("operator", (byte)this.operator.ordinal());
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.axisOptions.readFromNBT(tag, false);
        this.operator = ICondition.Operator.values()[tag.func_74771_c("operator")];
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        this.axisOptions.writeToBuffer(buf);
        buf.writeByte(this.operator.ordinal());
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.axisOptions.readFromBuffer(buf);
        this.operator = ICondition.Operator.values()[buf.readByte()];
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_COORDINATE;
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((ITextComponent)new StringTextComponent("Condition: \"" + this.getCondition() + "\""));
    }

    @Override
    public List<ITextComponent> getExtraStringInfo() {
        String condition = this.getCondition();
        return condition.isEmpty() ? Collections.emptyList() : Collections.singletonList(new StringTextComponent(condition));
    }

    public String getCondition() {
        return Arrays.stream(Direction.Axis.values()).filter(this.axisOptions::shouldCheck).map(axis -> String.format("%1$s1 %2$s %1$s2", axis.func_176719_a(), this.operator.toString())).collect(Collectors.joining(" and "));
    }
}

