/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;

public class SpeedBoostHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    private static final Vector3d FORWARD = new Vector3d(0.0, 0.0, 1.0);
    private static final Map<UUID, Vector3d> moveMap = new HashMap<UUID, Vector3d>();

    @Override
    public ResourceLocation getID() {
        return PneumaticRegistry.RL("run_speed");
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[]{EnumUpgrade.SPEED};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.LEGS;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        PlayerEntity player = commonArmorHandler.getPlayer();
        double speedBoost = this.getSpeedBoostFromLegs(commonArmorHandler);
        if (speedBoost == 0.0) {
            return;
        }
        if (player.field_70170_p.field_72995_K && player.field_191988_bg > 0.0f) {
            JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getClientTracker().getJetBootsState(player);
            if (!player.func_233570_aj_() && jbState.isEnabled() && jbState.isBuilderMode()) {
                player.func_213309_a((float)commonArmorHandler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS) / 250.0f, FORWARD);
            }
            if (player.func_233570_aj_() && !player.func_70090_H()) {
                player.func_213309_a((float)speedBoost, FORWARD);
            }
        }
        if (!player.field_70170_p.field_72995_K && speedBoost > 0.0) {
            boolean moved;
            Vector3d prev = moveMap.get(player.func_110124_au());
            boolean bl = moved = prev != null && (Math.abs(player.func_226277_ct_() - prev.field_72450_a) > 1.0E-4 || Math.abs(player.func_226281_cx_() - prev.field_72449_c) > 1.0E-4);
            if (moved && player.func_233570_aj_() && !player.func_70090_H()) {
                int airUsage = (int)Math.ceil(1.0 * speedBoost * 8.0);
                commonArmorHandler.addAir(EquipmentSlotType.LEGS, -airUsage);
            }
            moveMap.put(player.func_110124_au(), player.func_213303_ch());
        }
    }

    public double getSpeedBoostFromLegs(ICommonArmorHandler commonArmorHandler) {
        if (commonArmorHandler.upgradeUsable(ArmorUpgradeRegistry.getInstance().runSpeedHandler, true)) {
            int speedUpgrades = commonArmorHandler.getUpgradeCount(EquipmentSlotType.LEGS, EnumUpgrade.SPEED);
            PlayerEntity player = commonArmorHandler.getPlayer();
            ItemStack armorStack = player.func_184582_a(EquipmentSlotType.LEGS);
            float speedBoostMult = (float)ItemPneumaticArmor.getIntData(armorStack, "speedBoost", 100, 0, 100) / 100.0f;
            return 0.035f * (float)speedUpgrades * speedBoostMult;
        }
        return 0.0;
    }
}

