/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;

public class JetBootsHandler
extends BaseArmorUpgradeHandler<JetBootsLocalState> {
    public static final int BUILDER_MODE_LEVEL = 3;
    public static final int STABLIZERS_LEVEL = 4;

    @Override
    public ResourceLocation getID() {
        return PneumaticRegistry.RL("jet_boots");
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[]{EnumUpgrade.JET_BOOTS};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.FEET;
    }

    @Override
    public Supplier<JetBootsLocalState> extensionData() {
        return JetBootsLocalState::new;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        int jetbootsCount = commonArmorHandler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS);
        if (jetbootsCount == 0) {
            return;
        }
        int jetbootsAirUsage = 0;
        PlayerEntity player = commonArmorHandler.getPlayer();
        JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
        JetBootsLocalState jbLocal = commonArmorHandler.getExtensionData(this);
        if (commonArmorHandler.hasMinPressure(EquipmentSlotType.FEET)) {
            if (jbState.isActive()) {
                if (jbState.isBuilderMode() && jetbootsCount >= 3) {
                    this.setYMotion((Entity)player, player.func_225608_bj_() ? 0.0 : 0.15 + 0.15 * (double)(jetbootsCount - 3));
                    jetbootsAirUsage = (int)((float)((Integer)ConfigHelper.common().armor.jetBootsAirUsage.get() * jetbootsCount) / 2.5f);
                } else {
                    Vector3d lookVec = player.func_70040_Z().func_186678_a(0.3 * (double)jetbootsCount);
                    jbLocal.updateAccel(lookVec);
                    lookVec = jbLocal.getEffectiveMotion(lookVec, player.func_184613_cA());
                    player.func_213293_j(lookVec.field_72450_a, player.func_233570_aj_() ? 0.0 : lookVec.field_72448_b, lookVec.field_72449_c);
                    jetbootsAirUsage = jbLocal.calcAirUsage(jetbootsCount);
                }
                if (player.func_70090_H()) {
                    jetbootsAirUsage *= 4;
                }
                jbLocal.tickActive();
            } else if (jbState.isEnabled() && !player.func_233570_aj_() && !player.func_184613_cA()) {
                double xMotion;
                boolean reallyHovering = !jbLocal.isSmartHover() || jbLocal.isHovering();
                boolean stopped = jbLocal.isFlightStabilizers() && jetbootsCount >= 4 && PneumaticCraftUtils.epsilonEquals(player.field_191988_bg, 0.0f) && PneumaticCraftUtils.epsilonEquals(player.field_70702_br, 0.0f);
                double d = xMotion = stopped ? 0.0 : player.func_213322_ci().field_72450_a;
                double yMotion = reallyHovering ? (player.func_225608_bj_() ? -0.45 : -0.1 + 0.02 * (double)jetbootsCount) : player.func_213322_ci().field_72448_b;
                double zMotion = stopped ? 0.0 : player.func_213322_ci().field_72449_c;
                player.func_213317_d(new Vector3d(xMotion, yMotion, zMotion));
                if (reallyHovering) {
                    player.field_70143_R = 0.0f;
                }
                jetbootsAirUsage = reallyHovering ? (int)((float)((Integer)ConfigHelper.common().armor.jetBootsAirUsage.get()).intValue() * (player.func_225608_bj_() ? 0.25f : 0.5f)) : 0;
                jbLocal.resetAccel();
            } else if (player.func_233570_aj_()) {
                jbLocal.setHovering(false);
            } else {
                jbLocal.resetAccel();
            }
        } else {
            if (jbState.isEnabled() && !player.func_233570_aj_() && !player.func_184613_cA() && jbLocal.isHovering()) {
                jetbootsAirUsage = 1;
            }
            this.setJetBootsActive(commonArmorHandler, false);
        }
        if (jetbootsAirUsage != 0 && !player.field_70170_p.field_72995_K) {
            if (jbLocal.getPrevJetBootsAirUsage() == 0) {
                NetworkHandler.sendToAllTracking(new PacketPlayMovingSound(MovingSounds.Sound.JET_BOOTS, PacketPlayMovingSound.SoundSource.of((Entity)player)), player.field_70170_p, player.func_233580_cy_());
                AdvancementTriggers.FLIGHT.trigger((ServerPlayerEntity)player);
            }
            if (player.field_70123_F) {
                double vel = player.func_213322_ci().func_72433_c();
                if (player.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    vel *= 2.0;
                } else if (player.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    vel *= 1.5;
                }
                if (vel > 2.0) {
                    player.func_184185_a(vel > 2.5 ? SoundEvents.field_187655_bw : SoundEvents.field_187545_bE, 1.0f, 1.0f);
                    player.func_70097_a(DamageSource.field_188406_j, (float)vel);
                    AdvancementTriggers.FLY_INTO_WALL.trigger((ServerPlayerEntity)player);
                }
            }
            commonArmorHandler.addAir(EquipmentSlotType.FEET, -jetbootsAirUsage);
        }
        jbLocal.setPrevJetBootsAirUsage(jetbootsAirUsage);
    }

    @Override
    public void onInit(ICommonArmorHandler commonArmorHandler) {
        PlayerEntity player = commonArmorHandler.getPlayer();
        ItemStack armorStack = player.func_184582_a(EquipmentSlotType.FEET);
        JetBootsLocalState jbLocal = commonArmorHandler.getExtensionData(this);
        jbLocal.flightStabilizers = ItemPneumaticArmor.getBooleanData(armorStack, "JetBootsStabilizers", false);
        jbLocal.jetBootsPower = (float)ItemPneumaticArmor.getIntData(armorStack, "JetBootsPower", 100, 0, 100) / 100.0f;
        jbLocal.smartHover = ItemPneumaticArmor.getBooleanData(armorStack, "SmartHover", false);
        boolean jetBootsBuilderMode = ItemPneumaticArmor.getBooleanData(armorStack, "JetBootsBuilderMode", false);
        JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
        JetBootsStateTracker.getTracker(player).setJetBootsState(player, jbState.isEnabled(), jbState.isActive(), jetBootsBuilderMode);
    }

    @Override
    public void onToggle(ICommonArmorHandler commonArmorHandler, boolean newState) {
        PlayerEntity player = commonArmorHandler.getPlayer();
        JetBootsStateTracker tracker = JetBootsStateTracker.getTracker(player);
        JetBootsStateTracker.JetBootsState jbs = tracker.getJetBootsState(player);
        tracker.setJetBootsState(player, newState, jbs.isActive(), jbs.isBuilderMode());
        super.onToggle(commonArmorHandler, newState);
    }

    @Override
    public void onDataFieldUpdated(ICommonArmorHandler commonArmorHandler, String tagName, INBT inbt) {
        PlayerEntity player = commonArmorHandler.getPlayer();
        JetBootsLocalState jbLocal = commonArmorHandler.getExtensionData(this);
        switch (tagName) {
            case "JetBootsBuilderMode": {
                JetBootsStateTracker.getTracker(player).getJetBootsState(player).setBuilderMode(((ByteNBT)inbt).func_150290_f() == 1);
                break;
            }
            case "JetBootsPower": {
                jbLocal.jetBootsPower = MathHelper.func_76131_a((float)((float)((IntNBT)inbt).func_150287_d() / 100.0f), (float)0.0f, (float)1.0f);
                break;
            }
            case "JetBootsStabilizers": {
                jbLocal.flightStabilizers = ((ByteNBT)inbt).func_150290_f() == 1;
                break;
            }
            case "SmartHover": {
                jbLocal.smartHover = ((ByteNBT)inbt).func_150290_f() == 1;
            }
        }
    }

    public void setJetBootsActive(ICommonArmorHandler commonArmorHandler, boolean newActive) {
        PlayerEntity player = commonArmorHandler.getPlayer();
        JetBootsStateTracker.JetBootsState jbs = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
        JetBootsLocalState jbLocal = commonArmorHandler.getExtensionData(this);
        if (!newActive) {
            jbLocal.resetActive();
            if (jbLocal.isFlightStabilizers() && jbs.isActive() && !jbs.isBuilderMode()) {
                if (!player.field_70170_p.field_72995_K) {
                    double l = Math.pow(player.func_213322_ci().func_72433_c(), 1.65);
                    commonArmorHandler.addAir(EquipmentSlotType.FEET, (int)(l * -50.0));
                    NetworkHandler.sendToAllTracking(new PacketSpawnParticle(AirParticleData.DENSE, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0, (int)(l * 2.0), 0.0, 0.0, 0.0), player.field_70170_p, player.func_233580_cy_());
                }
                player.func_213317_d(Vector3d.field_186680_a);
            }
        }
        if (jbLocal.isSmartHover()) {
            jbLocal.setHovering(true);
        }
        JetBootsStateTracker.getTracker(player).setJetBootsState(player, jbs.isEnabled(), newActive, jbs.isBuilderMode());
        player.setForcedPose(newActive && !jbs.isBuilderMode() ? Pose.FALL_FLYING : null);
    }

    private void setYMotion(Entity entity, double y) {
        Vector3d v = entity.func_213322_ci();
        v = v.func_72441_c(0.0, y - v.field_72448_b, 0.0);
        entity.func_213317_d(v);
    }

    public JetBootsStateTracker.JetBootsState getJetBootsSyncedState(ICommonArmorHandler commonArmorHandler) {
        return JetBootsStateTracker.getTracker(commonArmorHandler.getPlayer()).getJetBootsState(commonArmorHandler.getPlayer());
    }

    public static class JetBootsLocalState
    implements IArmorExtensionData {
        public boolean smartHover;
        public boolean flightStabilizers;
        public float jetBootsPower;
        private float flightAccel = 1.0f;
        private int prevJetBootsAirUsage;
        private int jetBootsActiveTicks;
        private boolean hovering;

        public void tickActive() {
            ++this.jetBootsActiveTicks;
        }

        public void resetActive() {
            this.jetBootsActiveTicks = 0;
        }

        public void updateAccel(Vector3d lookVec) {
            float div = lookVec.field_72448_b > 0.0 ? -64.0f : -16.0f;
            this.flightAccel = MathHelper.func_76131_a((float)(this.flightAccel + (float)lookVec.field_72448_b / div), (float)0.8f, (float)4.2f);
        }

        public Vector3d getEffectiveMotion(Vector3d lookVec, boolean gliding) {
            lookVec = lookVec.func_186678_a((double)(this.flightAccel * this.jetBootsPower));
            if (!gliding && this.jetBootsActiveTicks < 20 && this.jetBootsActiveTicks > 0) {
                lookVec = lookVec.func_186678_a((double)this.jetBootsActiveTicks * 0.05);
            }
            return lookVec;
        }

        public boolean isHovering() {
            return this.hovering;
        }

        public void setHovering(boolean hovering) {
            this.hovering = hovering;
        }

        public int getPrevJetBootsAirUsage() {
            return this.prevJetBootsAirUsage;
        }

        public void setPrevJetBootsAirUsage(int prevJetBootsAirUsage) {
            this.prevJetBootsAirUsage = prevJetBootsAirUsage;
        }

        public void resetAccel() {
            this.flightAccel = 1.0f;
        }

        public int calcAirUsage(int jetbootsCount) {
            return (int)((float)((Integer)ConfigHelper.common().armor.jetBootsAirUsage.get() * jetbootsCount) * this.jetBootsPower);
        }

        public boolean isSmartHover() {
            return this.smartHover;
        }

        public boolean isFlightStabilizers() {
            return this.flightStabilizers;
        }
    }
}

