/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ChargingHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    @Override
    public ResourceLocation getID() {
        return PneumaticRegistry.RL("charging");
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[]{EnumUpgrade.CHARGING};
    }

    @Override
    public int getMaxInstallableUpgrades(EnumUpgrade upgrade) {
        return 6;
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.CHEST;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        PlayerEntity player = commonArmorHandler.getPlayer();
        if (player.field_70170_p.field_72995_K || !enabled || player.field_70170_p.func_82737_E() % 20L != 5L) {
            return;
        }
        int upgrades = commonArmorHandler.getUpgradeCount(EquipmentSlotType.CHEST, EnumUpgrade.CHARGING);
        int airAmount = upgrades * 100 + 100;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            if (slot == EquipmentSlotType.CHEST) continue;
            if (!commonArmorHandler.hasMinPressure(EquipmentSlotType.CHEST)) {
                return;
            }
            this.tryPressurize(commonArmorHandler, airAmount, player.func_184582_a(slot));
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!commonArmorHandler.hasMinPressure(EquipmentSlotType.CHEST)) {
                return;
            }
            this.tryPressurize(commonArmorHandler, airAmount, stack);
        }
    }

    private void tryPressurize(ICommonArmorHandler commonArmorHandler, int airAmount, ItemStack destStack) {
        if (destStack.func_190926_b()) {
            return;
        }
        destStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(destHandler -> {
            float pressure = destHandler.getPressure();
            if (pressure < destHandler.maxPressure() && pressure < commonArmorHandler.getArmorPressure(EquipmentSlotType.CHEST)) {
                int currentAir = destHandler.getAir();
                int targetAir = (int)(commonArmorHandler.getArmorPressure(EquipmentSlotType.CHEST) * (float)destHandler.getVolume());
                int amountToMove = MathHelper.func_76125_a((int)(targetAir - currentAir), (int)(-airAmount), (int)airAmount);
                destHandler.addAir(amountToMove);
                commonArmorHandler.addAir(EquipmentSlotType.CHEST, -amountToMove);
            }
        });
    }
}

