/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.ItemMachineUpgrade;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CommonArmorHandler
implements ICommonArmorHandler {
    private static final CommonArmorHandler clientHandler = new CommonArmorHandler(null);
    private static final CommonArmorHandler serverHandler = new CommonArmorHandler(null);
    private static final Vector3d FORWARD = new Vector3d(0.0, 0.0, 1.0);
    public static final float CRITICAL_PRESSURE = 0.1f;
    public static final float LOW_PRESSURE = 0.5f;
    private final HashMap<UUID, CommonArmorHandler> playerHandlers = new HashMap();
    private PlayerEntity player;
    private final boolean[][] upgradeRenderersInserted = new boolean[4][];
    private final boolean[][] upgradeRenderersEnabled = new boolean[4][];
    private final int[] ticksSinceEquip = new int[4];
    private final List<LazyOptional<IAirHandlerItem>> airHandlers = new ArrayList<LazyOptional<IAirHandlerItem>>();
    private final List<EnumMap<EnumUpgrade, Integer>> upgradeMatrix = new ArrayList<EnumMap<EnumUpgrade, Integer>>();
    private final int[] startupTimes = new int[4];
    private final IArmorExtensionData[][] extensionData = new IArmorExtensionData[4][];
    private boolean isValid;

    private CommonArmorHandler(PlayerEntity player) {
        this.player = player;
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            List<IArmorUpgradeHandler<?>> upgradeHandlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
            this.upgradeRenderersInserted[slot.func_188454_b()] = new boolean[upgradeHandlers.size()];
            this.upgradeRenderersEnabled[slot.func_188454_b()] = new boolean[upgradeHandlers.size()];
            this.upgradeMatrix.add(new EnumMap(EnumUpgrade.class));
            this.airHandlers.add((LazyOptional<IAirHandlerItem>)LazyOptional.empty());
            this.extensionData[slot.func_188454_b()] = new IArmorExtensionData[upgradeHandlers.size()];
            for (IArmorUpgradeHandler<?> handler : upgradeHandlers) {
                this.extensionData[slot.func_188454_b()][handler.getIndex()] = (IArmorExtensionData)handler.extensionData().get();
            }
        }
        Arrays.fill(this.startupTimes, 200);
        this.isValid = true;
    }

    private static CommonArmorHandler getManagerInstance(PlayerEntity player) {
        return player.field_70170_p.field_72995_K ? clientHandler : serverHandler;
    }

    public static CommonArmorHandler getHandlerForPlayer(PlayerEntity player) {
        return CommonArmorHandler.getManagerInstance((PlayerEntity)player).playerHandlers.computeIfAbsent(player.func_110124_au(), v -> new CommonArmorHandler(player));
    }

    public static CommonArmorHandler getHandlerForPlayer() {
        return CommonArmorHandler.getHandlerForPlayer(ClientUtils.getClientPlayer());
    }

    @Override
    public <T extends IArmorExtensionData> T getExtensionData(IArmorUpgradeHandler<T> handler) {
        return (T)this.extensionData[handler.getEquipmentSlot().func_188454_b()][handler.getIndex()];
    }

    private static void clearHandlerForPlayer(PlayerEntity player) {
        CommonArmorHandler h = CommonArmorHandler.getManagerInstance(player);
        h.playerHandlers.computeIfPresent(player.func_110124_au(), (name, val) -> {
            val.invalidate();
            return null;
        });
    }

    public void tickArmorPiece(EquipmentSlotType slot) {
        ItemStack armorStack = this.player.func_184582_a(slot);
        boolean armorActive = false;
        if (armorStack.func_77973_b() instanceof ItemPneumaticArmor) {
            this.airHandlers.set(slot.func_188454_b(), (LazyOptional<IAirHandlerItem>)armorStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY));
            if (this.ticksSinceEquip[slot.func_188454_b()] == 0) {
                this.initArmorInventory(slot);
            }
            int n = slot.func_188454_b();
            this.ticksSinceEquip[n] = this.ticksSinceEquip[n] + 1;
            if (this.isArmorEnabled() && this.getArmorPressure(slot) > 0.0f) {
                float airUsage;
                armorActive = true;
                if (!this.player.field_70170_p.field_72995_K && this.isArmorReady(slot) && !this.player.func_184812_l_() && (airUsage = this.getIdleAirUsage(slot, false)) != 0.0f) {
                    this.addAir(slot, (int)(-airUsage));
                }
                this.doArmorActions(slot);
            }
        } else {
            this.airHandlers.set(slot.func_188454_b(), (LazyOptional<IAirHandlerItem>)LazyOptional.empty());
        }
        if (!armorActive) {
            if (this.ticksSinceEquip[slot.func_188454_b()] > 0) {
                this.onArmorRemoved(slot);
            }
            this.ticksSinceEquip[slot.func_188454_b()] = 0;
        }
    }

    public float getIdleAirUsage(EquipmentSlotType slot, boolean countDisabled) {
        float totalUsage = 0.0f;
        List<IArmorUpgradeHandler<?>> handlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
        for (int i = 0; i < handlers.size(); ++i) {
            if (!this.isUpgradeInserted(slot, i) || !countDisabled && !this.isUpgradeEnabled(slot, i)) continue;
            totalUsage += handlers.get(i).getIdleAirUsage(this);
        }
        return totalUsage;
    }

    private void onArmorRemoved(EquipmentSlotType slot) {
        List<IArmorUpgradeHandler<?>> handlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
        for (int i = 0; i < handlers.size(); ++i) {
            if (!this.isUpgradeInserted(slot, i)) continue;
            handlers.get(i).onShutdown(this);
        }
    }

    @Override
    public float addAir(EquipmentSlotType slot, int airAmount) {
        float oldPressure = this.getArmorPressure(slot);
        if (!this.player.func_184812_l_() || airAmount > 0) {
            this.airHandlers.get(slot.func_188454_b()).ifPresent(h -> h.addAir(airAmount));
        }
        return oldPressure;
    }

    private void doArmorActions(EquipmentSlotType slot) {
        if (!this.isArmorReady(slot)) {
            return;
        }
        List<IArmorUpgradeHandler<?>> handlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
        for (int i = 0; i < handlers.size(); ++i) {
            if (!this.isUpgradeInserted(slot, i)) continue;
            handlers.get(i).tick(this, this.isUpgradeEnabled(slot, i));
        }
        if (slot == EquipmentSlotType.FEET && this.player.field_70170_p.field_72995_K && this.player.func_70090_H() && this.player.field_191988_bg > 0.0f && this.isArmorReady(EquipmentSlotType.FEET) && this.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.FLIPPERS) > 0) {
            this.player.func_213309_a(this.player.func_233570_aj_() ? ((Double)ConfigHelper.common().armor.flippersSpeedBoostGround.get()).floatValue() : ((Double)ConfigHelper.common().armor.flippersSpeedBoostFloating.get()).floatValue(), FORWARD);
        }
        if (!this.player.field_70170_p.field_72995_K && this.getUpgradeCount(slot, EnumUpgrade.ITEM_LIFE) > 0) {
            this.tryRepairArmor(slot);
        }
    }

    private void tryRepairArmor(EquipmentSlotType slot) {
        int upgrades = this.getUpgradeCount(slot, EnumUpgrade.ITEM_LIFE, 5);
        int interval = 120 - 20 * upgrades;
        int airUsage = (Integer)ConfigHelper.common().armor.repairAirUsage.get() * upgrades;
        ItemStack armorStack = this.player.func_184582_a(slot);
        if (armorStack.func_77952_i() > 0 && this.hasMinPressure(slot) && this.ticksSinceEquip[slot.func_188454_b()] % interval == 0) {
            this.addAir(slot, -airUsage);
            armorStack.func_196085_b(armorStack.func_77952_i() - 1);
        }
    }

    public void initArmorInventory(EquipmentSlotType slot) {
        ItemStack armorStack = this.player.func_184582_a(slot);
        ItemStack[] upgradeStacks = UpgradableItemUtils.getUpgradeStacks(armorStack);
        Arrays.fill(this.upgradeRenderersInserted[slot.func_188454_b()], false);
        for (int i = 0; i < this.upgradeRenderersInserted[slot.func_188454_b()].length; ++i) {
            this.upgradeRenderersInserted[slot.func_188454_b()][i] = this.isModuleEnabled(upgradeStacks, ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).get(i));
        }
        this.upgradeMatrix.get(slot.func_188454_b()).clear();
        for (ItemStack stack : upgradeStacks) {
            if (!(stack.func_77973_b() instanceof ItemMachineUpgrade)) continue;
            ItemMachineUpgrade upgrade = (ItemMachineUpgrade)stack.func_77973_b();
            this.upgradeMatrix.get(slot.func_188454_b()).put(upgrade.getUpgradeType(), stack.func_190916_E() * upgrade.getTier());
        }
        this.startupTimes[slot.func_188454_b()] = (int)((double)((Integer)ConfigHelper.common().armor.armorStartupTime.get()).intValue() * Math.pow(0.8, this.getSpeedFromUpgrades(slot) - 1));
        ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).forEach(handler -> {
            if (this.isUpgradeInserted(slot, handler.getIndex())) {
                handler.onInit(this);
            }
        });
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public int getUpgradeCount(EquipmentSlotType slot, EnumUpgrade upgrade) {
        return this.upgradeMatrix.get(slot.func_188454_b()).getOrDefault((Object)upgrade, 0);
    }

    public int getUpgradeCount(EquipmentSlotType slot, EnumUpgrade upgrade, int max) {
        return Math.min(max, this.getUpgradeCount(slot, upgrade));
    }

    public boolean isUpgradeInserted(EquipmentSlotType slot, int featureIndex) {
        return this.upgradeRenderersInserted[slot.func_188454_b()][featureIndex];
    }

    public boolean isUpgradeEnabled(EquipmentSlotType slot, int featureIndex) {
        return this.upgradeRenderersEnabled[slot.func_188454_b()][featureIndex];
    }

    public void setUpgradeEnabled(EquipmentSlotType slot, byte featureIndex, boolean state) {
        this.upgradeRenderersEnabled[slot.func_188454_b()][featureIndex] = state;
        IArmorUpgradeHandler<?> handler = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).get(featureIndex);
        handler.onToggle(this, state);
    }

    public int getTicksSinceEquipped(EquipmentSlotType slot) {
        return this.ticksSinceEquip[slot.func_188454_b()];
    }

    private boolean isModuleEnabled(ItemStack[] helmetStacks, IArmorUpgradeHandler<?> handler) {
        for (EnumUpgrade requiredUpgrade : handler.getRequiredUpgrades()) {
            boolean found = false;
            for (ItemStack stack : helmetStacks) {
                if (EnumUpgrade.from(stack) != requiredUpgrade) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getSpeedFromUpgrades(EquipmentSlotType slot) {
        return 1 + this.getUpgradeCount(slot, EnumUpgrade.SPEED);
    }

    public int getStartupTime(EquipmentSlotType slot) {
        return this.startupTimes[slot.func_188454_b()];
    }

    public boolean isArmorReady(EquipmentSlotType slot) {
        return this.getTicksSinceEquipped(slot) > this.getStartupTime(slot);
    }

    @Override
    public float getArmorPressure(EquipmentSlotType slot) {
        return this.airHandlers.get(slot.func_188454_b()).map(IAirHandler::getPressure).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public boolean isArmorEnabled() {
        return this.isUpgradeEnabled(EquipmentSlotType.HEAD, ArmorUpgradeRegistry.getInstance().coreComponentsHandler.getIndex());
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void invalidate() {
        this.isValid = false;
    }

    @Override
    public boolean hasMinPressure(EquipmentSlotType slot) {
        return this.getArmorPressure(slot) >= 0.1f;
    }

    @Override
    public boolean upgradeUsable(IArmorUpgradeHandler<?> upgrade, boolean mustBeActive) {
        EquipmentSlotType slot = upgrade.getEquipmentSlot();
        int idx = upgrade.getIndex();
        return this.isArmorEnabled() && this.isArmorReady(slot) && this.hasMinPressure(slot) && this.isUpgradeInserted(slot, idx) && (!mustBeActive || this.isUpgradeEnabled(slot, idx));
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientListeners {
        @SubscribeEvent
        public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
            PlayerEntity player = ClientUtils.getClientPlayer();
            if (player != null) {
                CommonArmorHandler.clearHandlerForPlayer(player);
            }
        }

        @SubscribeEvent
        public static void tickEnd(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71439_g == null) {
                for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                    for (IArmorUpgradeClientHandler<?> handler : ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot)) {
                        handler.reset();
                    }
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Listeners {
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(event.player);
                for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                    handler.tickArmorPiece(slot);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
            CommonArmorHandler.clearHandlerForPlayer(event.getPlayer());
        }

        @SubscribeEvent
        public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
            PlayerEntity player;
            CommonArmorHandler handler;
            if (event.getEntity() instanceof PlayerEntity && (handler = (CommonArmorHandler)CommonArmorHandler.getManagerInstance(player = (PlayerEntity)event.getEntity()).playerHandlers.get(player.func_110124_au())) != null) {
                handler.player = player;
            }
        }
    }
}

