/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.AirConHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.BlockTrackerHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ChargingHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ChestplateLauncherHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoordTrackerHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoreComponentsHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.DroneDebugHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.EntityTrackerHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.HackHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.JetBootsHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.JumpBoostHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.KickHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.MagnetHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.NightVisionHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ReachDistanceHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ScubaHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.SearchHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.SpeedBoostHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.StepAssistHandler;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;

public enum ArmorUpgradeRegistry {
    INSTANCE;

    private final List<List<IArmorUpgradeHandler<?>>> upgradeHandlers;
    private final Map<ResourceLocation, IArmorUpgradeHandler<?>> byID = new HashMap();
    public static final EquipmentSlotType[] ARMOR_SLOTS;
    public final CoreComponentsHandler coreComponentsHandler;
    public final BlockTrackerHandler blockTrackerHandler;
    public final EntityTrackerHandler entityTrackerHandler;
    public final SearchHandler searchHandler;
    public final CoordTrackerHandler coordTrackerHandler;
    public final DroneDebugHandler droneDebugHandler;
    public final NightVisionHandler nightVisionHandler;
    public final ScubaHandler scubaHandler;
    public final HackHandler hackHandler;
    public final MagnetHandler magnetHandler;
    public final ChargingHandler chargingHandler;
    public final ChestplateLauncherHandler chestplateLauncherHandler;
    public final AirConHandler airConHandler;
    public final ReachDistanceHandler reachDistanceHandler;
    public final SpeedBoostHandler runSpeedHandler;
    public final JumpBoostHandler jumpBoostHandler;
    public final JetBootsHandler jetBootsHandler;
    public final StepAssistHandler stepAssistHandler;
    public final KickHandler kickHandler;

    public static ArmorUpgradeRegistry getInstance() {
        return INSTANCE;
    }

    private ArmorUpgradeRegistry() {
        this.upgradeHandlers = new ArrayList(4);
        for (int i = 0; i < 4; ++i) {
            this.upgradeHandlers.add(new ArrayList());
        }
        this.coreComponentsHandler = this.registerUpgradeHandler(new CoreComponentsHandler());
        this.blockTrackerHandler = this.registerUpgradeHandler(new BlockTrackerHandler());
        this.entityTrackerHandler = this.registerUpgradeHandler(new EntityTrackerHandler());
        this.searchHandler = this.registerUpgradeHandler(new SearchHandler());
        this.coordTrackerHandler = this.registerUpgradeHandler(new CoordTrackerHandler());
        this.droneDebugHandler = this.registerUpgradeHandler(new DroneDebugHandler());
        this.nightVisionHandler = this.registerUpgradeHandler(new NightVisionHandler());
        this.scubaHandler = this.registerUpgradeHandler(new ScubaHandler());
        this.hackHandler = this.registerUpgradeHandler(new HackHandler());
        this.magnetHandler = this.registerUpgradeHandler(new MagnetHandler());
        this.chargingHandler = this.registerUpgradeHandler(new ChargingHandler());
        this.chestplateLauncherHandler = this.registerUpgradeHandler(new ChestplateLauncherHandler());
        this.airConHandler = this.registerUpgradeHandler(new AirConHandler());
        this.reachDistanceHandler = this.registerUpgradeHandler(new ReachDistanceHandler());
        this.runSpeedHandler = this.registerUpgradeHandler(new SpeedBoostHandler());
        this.jumpBoostHandler = this.registerUpgradeHandler(new JumpBoostHandler());
        this.jetBootsHandler = this.registerUpgradeHandler(new JetBootsHandler());
        this.stepAssistHandler = this.registerUpgradeHandler(new StepAssistHandler());
        this.kickHandler = this.registerUpgradeHandler(new KickHandler());
    }

    public static void init() {
    }

    public static String getStringKey(ResourceLocation id) {
        return IArmorUpgradeHandler.getStringKey(id);
    }

    <T extends IArmorUpgradeHandler<?>> T registerUpgradeHandler(T handler) {
        List<IArmorUpgradeHandler<?>> l = this.upgradeHandlers.get(handler.getEquipmentSlot().func_188454_b());
        handler.setIndex(l.size());
        this.byID.put(handler.getID(), handler);
        l.add(handler);
        return handler;
    }

    public List<IArmorUpgradeHandler<?>> getHandlersForSlot(EquipmentSlotType slotType) {
        return this.upgradeHandlers.get(slotType.func_188454_b());
    }

    public IArmorUpgradeHandler<?> getUpgradeEntry(ResourceLocation upgradeID) {
        if (upgradeID == null) {
            return null;
        }
        return this.byID.get(upgradeID);
    }

    public Stream<IArmorUpgradeHandler<?>> entries() {
        return this.byID.values().stream();
    }

    static {
        ARMOR_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    }
}

